/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CustomScopeConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Map scopes;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    static /* synthetic */ Class class$org$springframework$beans$factory$config$Scope;

    public void setScopes(Map scopes) {
        this.scopes = scopes;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.scopes != null && this.scopes.size() > 0) {
            Iterator it = this.scopes.keySet().iterator();
            while (it.hasNext()) {
                String scopeName = this.resolveScopeName(it.next());
                Scope scope = this.resolveScope(this.scopes.get(scopeName));
                beanFactory.registerScope(scopeName, scope);
            }
        }
    }

    private String resolveScopeName(Object value) {
        String scopeName;
        if (value instanceof String && StringUtils.hasText((String)(scopeName = (String)value))) {
            return scopeName;
        }
        throw new BeanInitializationException("Invalid scope name [" + value + "] for custom scope registration - " + "needs to be a non-whitespace-only String");
    }

    private Scope resolveScope(Object value) {
        if (value instanceof String) {
            String className = (String)value;
            try {
                Class scopeType = ClassUtils.forName((String)className, (ClassLoader)this.beanClassLoader);
                return CustomScopeConfigurer.instantiateScope(scopeType);
            }
            catch (ClassNotFoundException ex) {
                throw new BeanInitializationException("Could not load required type [" + className + "] for custom scope", ex);
            }
        }
        if (value instanceof Class) {
            return CustomScopeConfigurer.instantiateScope((Class)value);
        }
        if (value instanceof Scope) {
            return (Scope)value;
        }
        throw new BeanInitializationException("Invalid scope value [" + value + "] for custom scope registration - " + "needs to be a fully qualified classname, Class, or Scope instance");
    }

    private static Scope instantiateScope(Class scopeType) {
        if ((class$org$springframework$beans$factory$config$Scope == null ? (class$org$springframework$beans$factory$config$Scope = CustomScopeConfigurer.class$("org.springframework.beans.factory.config.Scope")) : class$org$springframework$beans$factory$config$Scope).isAssignableFrom(scopeType)) {
            return (Scope)BeanUtils.instantiateClass(scopeType);
        }
        throw new BeanInitializationException("Invalid class type [" + scopeType + "] for custom scope : must be " + "assignable to the [" + ClassUtils.getQualifiedName((Class)(class$org$springframework$beans$factory$config$Scope == null ? (class$org$springframework$beans$factory$config$Scope = CustomScopeConfigurer.class$("org.springframework.beans.factory.config.Scope")) : class$org$springframework$beans$factory$config$Scope)) + "] type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

