/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractComponentDefinition;
import org.springframework.util.Assert;

public class BeanComponentDefinition
extends AbstractComponentDefinition {
    private final BeanDefinition beanDefinition;
    private final String beanName;
    private String description;
    private RuntimeBeanReference[] beanReferences;

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName) {
        Assert.notNull((Object)beanDefinition, (String)"'beanDefinition' cannot be null.");
        Assert.notNull((Object)beanName, (String)"'beanName' cannot be null.");
        this.beanDefinition = beanDefinition;
        this.beanName = beanName;
        this.createDescription();
        this.findBeanReferences();
    }

    private void findBeanReferences() {
        ArrayList<Object> references = new ArrayList<Object>();
        MutablePropertyValues propertyValues = this.beanDefinition.getPropertyValues();
        for (int i = 0; i < propertyValues.getPropertyValues().length; ++i) {
            PropertyValue propertyValue = propertyValues.getPropertyValues()[i];
            Object value = propertyValue.getValue();
            if (!(value instanceof RuntimeBeanReference)) continue;
            references.add(value);
        }
        this.beanReferences = references.toArray(new RuntimeBeanReference[references.size()]);
    }

    public BeanComponentDefinition(BeanDefinitionHolder holder) {
        Assert.notNull((Object)holder, (String)"'holder' cannot be null.");
        this.beanDefinition = holder.getBeanDefinition();
        this.beanName = holder.getBeanName();
        this.createDescription();
    }

    private void createDescription() {
        String beanType = ((AbstractBeanDefinition)this.beanDefinition).getBeanClassName();
        this.description = "Bean '" + this.getName() + "' of type '" + beanType + "'";
    }

    public String getName() {
        return this.beanName;
    }

    public String getDescription() {
        return this.description;
    }

    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.beanDefinition};
    }

    public RuntimeBeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    public Object getSource() {
        return this.beanDefinition.getSource();
    }
}

