/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;

public abstract class AutoProxyUtils {
    public static final String DEFAULT_PROXY_CONFIG_BEAN_NAME = "org.springframework.aop.framework.autoproxy.defaultProxyConfig";
    public static final String EXPOSED_INTERFACES_ATTRIBUTE = Conventions.getQualifiedAttributeName(AutoProxyUtils.class, (String)"exposedInterfaces");
    public static final Object ALL_INTERFACES_ATTRIBUTE_VALUE = new Class[0];
    public static final String PRESERVE_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(AutoProxyUtils.class, (String)"preserveTargetClass");
    public static final String ORIGINAL_TARGET_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(AutoProxyUtils.class, (String)"originalTargetClass");

    static void applyDefaultProxyConfig(ProxyConfig proxyConfig, BeanFactory beanFactory) {
        if (beanFactory.containsBean(DEFAULT_PROXY_CONFIG_BEAN_NAME)) {
            ProxyConfig defaultProxyConfig = (ProxyConfig)beanFactory.getBean(DEFAULT_PROXY_CONFIG_BEAN_NAME, ProxyConfig.class);
            proxyConfig.copyDefault(defaultProxyConfig);
        }
    }

    static Class<?> @Nullable [] determineExposedInterfaces(ConfigurableListableBeanFactory beanFactory, @Nullable String beanName) {
        if (beanName != null && beanFactory.containsBeanDefinition(beanName)) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
            Object interfaces = bd.getAttribute(EXPOSED_INTERFACES_ATTRIBUTE);
            if (interfaces instanceof Class[]) {
                Class[] ifcs = (Class[])interfaces;
                return ifcs;
            }
            if (interfaces instanceof Class) {
                Class ifc = (Class)interfaces;
                return new Class[]{ifc};
            }
        }
        return null;
    }

    public static boolean shouldProxyTargetClass(ConfigurableListableBeanFactory beanFactory, @Nullable String beanName) {
        if (beanName != null && beanFactory.containsBeanDefinition(beanName)) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
            return Boolean.TRUE.equals(bd.getAttribute(PRESERVE_TARGET_CLASS_ATTRIBUTE));
        }
        return false;
    }

    public static @Nullable Class<?> determineTargetClass(ConfigurableListableBeanFactory beanFactory, @Nullable String beanName) {
        BeanDefinition bd;
        Class targetClass;
        if (beanName == null) {
            return null;
        }
        if (beanFactory.containsBeanDefinition(beanName) && (targetClass = (Class)(bd = beanFactory.getMergedBeanDefinition(beanName)).getAttribute(ORIGINAL_TARGET_CLASS_ATTRIBUTE)) != null) {
            return targetClass;
        }
        return beanFactory.getType(beanName);
    }

    static void exposeTargetClass(ConfigurableListableBeanFactory beanFactory, @Nullable String beanName, Class<?> targetClass) {
        if (beanName != null && beanFactory.containsBeanDefinition(beanName)) {
            beanFactory.getMergedBeanDefinition(beanName).setAttribute(ORIGINAL_TARGET_CLASS_ATTRIBUTE, targetClass);
        }
    }

    static boolean isOriginalInstance(String beanName, Class<?> beanClass) {
        if (!StringUtils.hasLength((String)beanName) || beanName.length() != beanClass.getName().length() + ".ORIGINAL".length()) {
            return false;
        }
        return beanName.startsWith(beanClass.getName()) && beanName.endsWith(".ORIGINAL");
    }
}

