/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.config.AdviceEntry;
import org.springframework.aop.config.AdvisorComponentDefinition;
import org.springframework.aop.config.AdvisorEntry;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.config.AspectComponentDefinition;
import org.springframework.aop.config.AspectEntry;
import org.springframework.aop.config.PointcutComponentDefinition;
import org.springframework.aop.config.PointcutEntry;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ASPECT = "aspect";
    public static final String EXPRESSION = "expression";
    public static final String ID = "id";
    public static final String POINTCUT = "pointcut";
    public static final String ADVICE = "advice";
    public static final String ADVISOR = "advisor";
    public static final String ADVICE_REF = "advice-ref";
    public static final String POINTCUT_REF = "pointcut-ref";
    public static final String REF = "ref";
    public static final String KIND = "kind";
    public static final String BEFORE = "before";
    public static final String DECLARE_PARENTS = "declare-parents";
    public static final String TYPE_PATTERN = "types-matching";
    public static final String DEFAULT_IMPL = "default-impl";
    public static final String IMPLEMENT_INTERFACE = "implement-interface";
    public static final String AFTER = "after";
    public static final String AFTER_RETURNING = "afterReturning";
    public static final String AFTER_THROWING = "afterThrowing";
    public static final String AFTER_RETURNING_ELEMENT = "after-returning";
    public static final String AFTER_THROWING_ELEMENT = "after-throwing";
    public static final String AROUND = "around";
    public static final String PROXY_TARGET_CLASS = "proxy-target-class";
    public static final String TRUE = "true";
    public static final String RETURNING = "returning";
    public static final String RETURNING_PROPERTY = "returningName";
    public static final String THROWING = "throwing";
    public static final String THROWING_PROPERTY = "throwingName";
    public static final String ARG_NAMES = "arg-names";
    public static final String ARG_NAMES_PROPERTY = "argumentNames";
    public static final String ASPECT_NAME_PROPERTY = "aspectName";
    public static final String ASPECT_BEAN_PROPERTY = "aspectBean";
    public static final String DECLARATION_ORDER_PROPERTY = "declarationOrder";
    public static final String ORDER_PROPERTY = "order";
    private static final int METHOD_INDEX = 0;
    private static final int POINTCUT_INDEX = 1;
    private static final int ASPECT_INSTANCE_FACTORY_INDEX = 2;
    private static final int PARAMETER_NAME_DISCOVERER = 3;
    private ParseState parseState = new ParseState();
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$DeclareParentsAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$config$MethodLocatingFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory;
    static /* synthetic */ Class class$org$springframework$core$PrioritizedParameterNameDiscoverer;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAroundAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJExpressionPointcut;

    ConfigBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.configureAutoProxyCreator(parserContext, element);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (POINTCUT.equals(localName)) {
                this.parsePointcut((Element)node, parserContext);
                continue;
            }
            if (ADVISOR.equals(localName)) {
                this.parseAdvisor((Element)node, parserContext);
                continue;
            }
            if (!ASPECT.equals(localName)) continue;
            this.parseAspect((Element)node, parserContext);
        }
        return null;
    }

    private void configureAutoProxyCreator(ParserContext parserContext, Element element) {
        AopNamespaceUtils.registerAspectJAutoProxyCreatorIfNecessary(parserContext);
        boolean proxyTargetClass = TRUE.equals(element.getAttribute(PROXY_TARGET_CLASS));
        if (proxyTargetClass) {
            AopNamespaceUtils.forceAutoProxyCreatorToUseClassProxying(parserContext.getRegistry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAdvisor(Element advisorElement, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        AbstractBeanDefinition advisorDefinition = this.createAdvisorBeanDefinition(advisorElement);
        String advisorBeanName = advisorElement.getAttribute(ID);
        if (!StringUtils.hasText((String)advisorBeanName)) {
            advisorBeanName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)advisorDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
        }
        try {
            this.parseState.push((ParseState.Entry)new AdvisorEntry(advisorBeanName));
            String pointcutBeanName = this.parsePointcutProperty(advisorElement, advisorDefinition.getPropertyValues(), parserContext);
            registry.registerBeanDefinition(advisorBeanName, (BeanDefinition)advisorDefinition);
            boolean pointcutRef = advisorElement.hasAttribute(POINTCUT_REF);
            if (pointcutBeanName != null) {
                this.fireAdvisorEvent(advisorBeanName, pointcutBeanName, advisorDefinition, parserContext, pointcutRef);
            }
        }
        finally {
            this.parseState.pop();
        }
    }

    private void fireAdvisorEvent(String advisorBeanName, String pointcutBeanName, AbstractBeanDefinition advisorDefinition, ParserContext parserContext, boolean pointcutRef) {
        AdvisorComponentDefinition componentDefinition;
        if (pointcutRef) {
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, (BeanDefinition)advisorDefinition);
        } else {
            BeanDefinition pointcutDefinition = parserContext.getRegistry().getBeanDefinition(pointcutBeanName);
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, (BeanDefinition)advisorDefinition, pointcutDefinition);
        }
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)componentDefinition);
    }

    private AbstractBeanDefinition createAdvisorBeanDefinition(Element advisorElement) {
        RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
        advisorDefinition.setSource((Object)advisorElement);
        MutablePropertyValues mpvs = advisorDefinition.getPropertyValues();
        if (advisorElement.hasAttribute(ORDER_PROPERTY)) {
            mpvs.addPropertyValue(ORDER_PROPERTY, (Object)advisorElement.getAttribute(ORDER_PROPERTY));
        }
        advisorDefinition.setPropertyValues(mpvs);
        mpvs.addPropertyValue(ADVICE, (Object)new RuntimeBeanReference(advisorElement.getAttribute(ADVICE_REF)));
        return advisorDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAspect(Element aspectElement, ParserContext parserContext) {
        String aspectName = aspectElement.getAttribute(REF);
        String aspectId = aspectElement.getAttribute(ID);
        try {
            this.parseState.push((ParseState.Entry)new AspectEntry(aspectId, aspectName));
            ArrayList<AbstractBeanDefinition> beanDefinitions = new ArrayList<AbstractBeanDefinition>();
            ArrayList<Object> beanReferences = new ArrayList<Object>();
            beanReferences.add(new RuntimeBeanReference(aspectName));
            List pointcuts = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)POINTCUT);
            for (int i = 0; i < pointcuts.size(); ++i) {
                Element pointcutElement = (Element)pointcuts.get(i);
                beanDefinitions.add(this.parsePointcut(pointcutElement, parserContext));
            }
            List declareParents = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)DECLARE_PARENTS);
            for (int i = 0; i < declareParents.size(); ++i) {
                Element declareParentsElement = (Element)declareParents.get(i);
                beanDefinitions.add(this.parseDeclareParents(declareParentsElement, parserContext));
            }
            NodeList nodeList = aspectElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!this.isAdviceNode(node)) continue;
                AbstractBeanDefinition adviceDefinition = this.parseAdvice(aspectName, i, (Element)node, parserContext);
                Object pointcut = adviceDefinition.getPropertyValues().getPropertyValue(POINTCUT).getValue();
                if (pointcut instanceof RuntimeBeanReference) {
                    beanReferences.add(pointcut);
                }
                beanDefinitions.add(adviceDefinition);
            }
            this.fireAspectEvent(aspectElement, aspectId, beanDefinitions, beanReferences, parserContext);
        }
        finally {
            this.parseState.pop();
        }
    }

    private void fireAspectEvent(Element aspectElement, String aspectId, List beanDefinitions, List beanReferences, ParserContext parserContext) {
        BeanDefinition[] finalBeanDefinitions = beanDefinitions.toArray(new BeanDefinition[beanDefinitions.size()]);
        RuntimeBeanReference[] finalBeanReferences = beanReferences.toArray(new RuntimeBeanReference[beanReferences.size()]);
        AspectComponentDefinition acd = new AspectComponentDefinition(aspectElement, aspectId, finalBeanDefinitions, finalBeanReferences);
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)acd);
    }

    private boolean isAdviceNode(Node aNode) {
        if (!(aNode instanceof Element)) {
            return false;
        }
        String name = aNode.getLocalName();
        return BEFORE.equals(name) || AFTER.equals(name) || AFTER_RETURNING_ELEMENT.equals(name) || AFTER_THROWING_ELEMENT.equals(name) || AROUND.equals(name);
    }

    private AbstractBeanDefinition parseDeclareParents(Element declareParentsElement, ParserContext parserContext) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$aop$aspectj$DeclareParentsAdvisor == null ? (class$org$springframework$aop$aspectj$DeclareParentsAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.DeclareParentsAdvisor")) : class$org$springframework$aop$aspectj$DeclareParentsAdvisor)).addConstructorArg((Object)declareParentsElement.getAttribute(IMPLEMENT_INTERFACE)).addConstructorArg((Object)declareParentsElement.getAttribute(TYPE_PATTERN)).addConstructorArg((Object)declareParentsElement.getAttribute(DEFAULT_IMPL)).setSource((Object)declareParentsElement).getBeanDefinition();
        String name = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)false);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parseAdvice(String aspectName, int order, Element adviceElement, ParserContext parserContext) {
        RootBeanDefinition advisorDefinition = null;
        try {
            this.parseState.push((ParseState.Entry)new AdviceEntry(adviceElement.getLocalName()));
            MutablePropertyValues advisorProperties = new MutablePropertyValues();
            RootBeanDefinition methodDefinition = new RootBeanDefinition(class$org$springframework$aop$config$MethodLocatingFactoryBean == null ? (class$org$springframework$aop$config$MethodLocatingFactoryBean = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.MethodLocatingFactoryBean")) : class$org$springframework$aop$config$MethodLocatingFactoryBean);
            methodDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)aspectName);
            methodDefinition.getPropertyValues().addPropertyValue("methodName", (Object)adviceElement.getAttribute("method"));
            methodDefinition.setSynthetic(true);
            RootBeanDefinition instanceFactoryDefinition = new RootBeanDefinition(class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory == null ? (class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.BeanFactoryAspectInstanceFactory")) : class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory);
            instanceFactoryDefinition.getPropertyValues().addPropertyValue("aspectBeanName", (Object)aspectName);
            AbstractBeanDefinition adviceDefinition = this.createAdviceDefinition(adviceElement, advisorProperties, parserContext, aspectName, order, methodDefinition, instanceFactoryDefinition);
            advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
            advisorDefinition.setSource((Object)adviceElement);
            advisorDefinition.setPropertyValues(advisorProperties);
            advisorDefinition.getPropertyValues().addPropertyValue(ADVICE, (Object)adviceDefinition);
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            String id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)advisorDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
            registry.registerBeanDefinition(id, (BeanDefinition)advisorDefinition);
        }
        finally {
            this.parseState.pop();
        }
        return advisorDefinition;
    }

    private AbstractBeanDefinition createAdviceDefinition(Element adviceElement, MutablePropertyValues advisorProperties, ParserContext parserContext, String aspectName, int order, RootBeanDefinition methodDefinition, RootBeanDefinition instanceFactoryDefinition) {
        String pointcutBeanName = this.parsePointcutProperty(adviceElement, advisorProperties, parserContext);
        RootBeanDefinition adviceDefinition = new RootBeanDefinition(this.getAdviceClass(adviceElement));
        adviceDefinition.setSource((Object)adviceElement);
        boolean isAroundAdvice = AROUND.equals(adviceElement.getLocalName());
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_NAME_PROPERTY, (Object)aspectName);
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_BEAN_PROPERTY, (Object)new RuntimeBeanReference(aspectName));
        adviceDefinition.getPropertyValues().addPropertyValue(DECLARATION_ORDER_PROPERTY, (Object)new Integer(order));
        if (adviceElement.hasAttribute(RETURNING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(RETURNING_PROPERTY, (Object)adviceElement.getAttribute(RETURNING));
        }
        if (adviceElement.hasAttribute(THROWING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(THROWING_PROPERTY, (Object)adviceElement.getAttribute(THROWING));
        }
        if (adviceElement.hasAttribute(ARG_NAMES)) {
            adviceDefinition.getPropertyValues().addPropertyValue(ARG_NAMES_PROPERTY, (Object)adviceElement.getAttribute(ARG_NAMES));
        }
        ConstructorArgumentValues cav = new ConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, (Object)methodDefinition);
        cav.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(pointcutBeanName));
        cav.addIndexedArgumentValue(2, (Object)instanceFactoryDefinition);
        if (isAroundAdvice) {
            this.extendAdviceConstructorArgs(cav);
        }
        adviceDefinition.setConstructorArgumentValues(cav);
        return adviceDefinition;
    }

    private void extendAdviceConstructorArgs(ConstructorArgumentValues cav) {
        RootBeanDefinition discovererDefinition = new RootBeanDefinition(class$org$springframework$core$PrioritizedParameterNameDiscoverer == null ? (class$org$springframework$core$PrioritizedParameterNameDiscoverer = ConfigBeanDefinitionParser.class$("org.springframework.core.PrioritizedParameterNameDiscoverer")) : class$org$springframework$core$PrioritizedParameterNameDiscoverer);
        cav.addIndexedArgumentValue(3, (Object)discovererDefinition);
    }

    private Class getAdviceClass(Element adviceElement) {
        String elementName = adviceElement.getLocalName();
        if (BEFORE.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
        }
        if (AFTER.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
        }
        if (AFTER_RETURNING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
        }
        if (AFTER_THROWING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
        }
        if (AROUND.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
        }
        throw new IllegalArgumentException("Unknown advice kind [" + elementName + "].");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parsePointcut(Element pointcutElement, ParserContext parserContext) {
        String id = pointcutElement.getAttribute(ID);
        String expression = pointcutElement.getAttribute(EXPRESSION);
        AbstractBeanDefinition pointcutDefinition = null;
        try {
            this.parseState.push((ParseState.Entry)new PointcutEntry(id));
            pointcutDefinition = this.createPointcutDefinition(expression);
            pointcutDefinition.setSource((Object)pointcutElement);
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            if (!StringUtils.hasText((String)id)) {
                id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)pointcutDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
            }
            registry.registerBeanDefinition(id, (BeanDefinition)pointcutDefinition);
            PointcutComponentDefinition componentDefinition = new PointcutComponentDefinition(id, (BeanDefinition)pointcutDefinition, expression);
            parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)componentDefinition);
        }
        finally {
            this.parseState.pop();
        }
        return pointcutDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parsePointcutProperty(Element element, MutablePropertyValues mpvs, ParserContext parserContext) {
        if (element.hasAttribute(POINTCUT) && element.hasAttribute(POINTCUT_REF)) {
            parserContext.getReaderContext().error("Cannot define both 'pointcut' and 'pointcut-ref' on 'advisor' tag.", (Object)element, this.parseState.snapshot());
            return null;
        }
        if (element.hasAttribute(POINTCUT)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            AbstractBeanDefinition pointcutDefinition = this.createPointcutDefinition(element.getAttribute(POINTCUT));
            pointcutDefinition.setSource((Object)element.getAttributeNode(POINTCUT));
            String pointcutName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)pointcutDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
            try {
                this.parseState.push((ParseState.Entry)new PointcutEntry(pointcutName));
                registry.registerBeanDefinition(pointcutName, (BeanDefinition)pointcutDefinition);
                mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutName));
            }
            finally {
                this.parseState.pop();
            }
            return pointcutName;
        }
        if (element.hasAttribute(POINTCUT_REF)) {
            String pointcutRef = element.getAttribute(POINTCUT_REF);
            try {
                this.parseState.push((ParseState.Entry)new PointcutEntry(pointcutRef));
                mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutRef));
            }
            finally {
                this.parseState.pop();
            }
            return pointcutRef;
        }
        parserContext.getReaderContext().error("Must define one of 'pointcut' or 'pointcut-ref' on 'advisor'.", (Object)element, this.parseState.snapshot());
        return null;
    }

    protected AbstractBeanDefinition createPointcutDefinition(String expression) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(class$org$springframework$aop$aspectj$AspectJExpressionPointcut == null ? (class$org$springframework$aop$aspectj$AspectJExpressionPointcut = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJExpressionPointcut")) : class$org$springframework$aop$aspectj$AspectJExpressionPointcut);
        beanDefinition.setSingleton(false);
        beanDefinition.getPropertyValues().addPropertyValue(EXPRESSION, (Object)expression);
        return beanDefinition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

