/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.ObjectUtils;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private List mappedNames = new LinkedList();

    public void setMappedName(String mappedName) {
        this.setMappedNames(new String[]{mappedName});
    }

    public void setMappedNames(String[] mappedNames) {
        this.mappedNames = new LinkedList();
        if (mappedNames != null) {
            for (int i = 0; i < mappedNames.length; ++i) {
                this.mappedNames.add(mappedNames[i]);
            }
        }
    }

    public NameMatchMethodPointcut addMethodName(String name) {
        this.mappedNames.add(name);
        return this;
    }

    public boolean matches(Method method, Class targetClass) {
        for (int i = 0; i < this.mappedNames.size(); ++i) {
            String mappedName = (String)this.mappedNames.get(i);
            if (!mappedName.equals(method.getName()) && !this.isMatch(method.getName(), mappedName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1, mappedName.length()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NameMatchMethodPointcut && ObjectUtils.nullSafeEquals((Object)this.mappedNames, (Object)((NameMatchMethodPointcut)other).mappedNames);
    }

    public int hashCode() {
        return this.mappedNames != null ? ((Object)this.mappedNames).hashCode() : 0;
    }
}

