/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security.provider;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.security.SocialAuthenticationRedirectException;
import org.springframework.social.security.SocialAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SocialAuthenticationService<S> {
    public ConnectionCardinality getConnectionCardinality();

    public ConnectionFactory<S> getConnectionFactory();

    public SocialAuthenticationToken getAuthToken(HttpServletRequest var1, HttpServletResponse var2) throws SocialAuthenticationRedirectException;

    public String getConnectionAddedRedirectUrl(HttpServletRequest var1, Connection<?> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionCardinality {
        ONE_TO_ONE(false, false),
        ONE_TO_MANY(false, true),
        MANY_TO_ONE(true, false),
        MANY_TO_MANY(true, true);

        private final boolean multiUserId;
        private final boolean multiProviderUserId;

        private ConnectionCardinality(boolean multiUserId, boolean multiProviderUserId) {
            this.multiUserId = multiUserId;
            this.multiProviderUserId = multiProviderUserId;
        }

        public boolean isMultiUserId() {
            return this.multiUserId;
        }

        public boolean isMultiProviderUserId() {
            return this.multiProviderUserId;
        }

        public boolean isAuthenticatePossible() {
            return !this.isMultiUserId();
        }
    }
}

