/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialAuthenticationToken
extends AbstractAuthenticationToken {
    private final String providerId;
    private final Serializable principle;
    private final Connection<?> connection;
    private final Map<String, String> providerAccountData;

    public SocialAuthenticationToken(Connection<?> connection, Map<String, String> providerAccountData) {
        super(null);
        Assert.notNull(connection);
        ConnectionData connectionData = connection.createData();
        Assert.notNull((Object)connectionData.getProviderId());
        if (connectionData.getExpireTime() != null && connectionData.getExpireTime() < System.currentTimeMillis()) {
            throw new IllegalArgumentException("connection.expireTime < currentTime");
        }
        this.providerId = connectionData.getProviderId();
        this.connection = connection;
        this.principle = null;
        this.providerAccountData = providerAccountData != null ? Collections.unmodifiableMap(new HashMap<String, String>(providerAccountData)) : Collections.emptyMap();
        super.setAuthenticated(false);
    }

    public SocialAuthenticationToken(Connection<?> connection, Serializable details, Map<String, String> providerAccountData, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.notNull(connection);
        this.connection = connection;
        ConnectionData connectionData = connection.createData();
        Assert.notNull((Object)connectionData.getProviderId());
        this.providerId = connectionData.getProviderId();
        if (details == null) {
            throw new NullPointerException("details");
        }
        this.principle = details;
        this.providerAccountData = providerAccountData != null ? Collections.unmodifiableMap(new HashMap<String, String>(providerAccountData)) : Collections.emptyMap();
        super.setAuthenticated(true);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public Object getCredentials() {
        return null;
    }

    public Serializable getPrincipal() {
        return this.principle;
    }

    public Connection<?> getConnection() {
        return this.connection;
    }

    public Map<String, String> getProviderAccountData() {
        return this.providerAccountData;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (!isAuthenticated) {
            super.setAuthenticated(false);
        } else if (!super.isAuthenticated()) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        }
    }
}

