/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.Shell;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.event.AbstractShellStatusPublisher;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.event.ShellStatus;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.MathUtils;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.shell.support.util.VersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShell
extends AbstractShellStatusPublisher
implements Shell {
    private static final String MY_SLOT = AbstractShell.class.getName();
    protected static final String ROO_PROMPT = "spring> ";
    public static String completionKeys = "TAB";
    public static String shellPrompt = "spring> ";
    protected final Logger logger = HandlerUtils.getLogger(this.getClass());
    protected boolean inBlockComment;
    protected ExitShellRequest exitShellRequest;

    protected abstract Collection<URL> findResources(String var1);

    protected abstract String getHomeAsString();

    protected abstract ExecutionStrategy getExecutionStrategy();

    protected abstract Parser getParser();

    @CliCommand(value={"script"}, help="Parses the specified resource file and executes its commands")
    public void script(@CliOption(key={"", "file"}, help="The file to locate and execute", mandatory=true) File script, @CliOption(key={"lineNumbers"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display line numbers when executing the script") boolean lineNumbers) {
        Assert.notNull((Object)script, (String)"Script file to parse is required");
        double startedNanoseconds = System.nanoTime();
        InputStream inputStream = this.openScript(script);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(inputStream));
            int i = 0;
            while ((line = in.readLine()) != null) {
                ++i;
                if (lineNumbers) {
                    this.logger.fine("Line " + i + ": " + line);
                } else {
                    this.logger.fine(line);
                }
                if ("".equals(line.trim())) continue;
                boolean success = this.executeScriptLine(line);
                if (success && (line.trim().startsWith("q") || line.trim().startsWith("ex"))) break;
                if (success) continue;
                throw new IllegalStateException("Script execution aborted");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, in);
                double executionDurationInSeconds = ((double)System.nanoTime() - startedNanoseconds) / 1.0E9;
                this.logger.fine("Script required " + MathUtils.round(executionDurationInSeconds, 3) + " seconds to execute");
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, in);
        double executionDurationInSeconds = ((double)System.nanoTime() - startedNanoseconds) / 1.0E9;
        this.logger.fine("Script required " + MathUtils.round(executionDurationInSeconds, 3) + " seconds to execute");
    }

    private InputStream openScript(File script) {
        try {
            return new BufferedInputStream(new FileInputStream(script));
        }
        catch (FileNotFoundException fnfe) {
            Collection<URL> urls = this.findResources(script.getName());
            Assert.notNull(urls, (String)("Unexpected error looking for '" + script.getName() + "'"));
            Assert.notEmpty(urls, (String)("Script '" + script + "' not found on disk or in classpath"));
            Assert.isTrue((urls.size() == 1 ? 1 : 0) != 0, (String)("More than one '" + script + "' was found in the classpath; unable to continue"));
            try {
                return urls.iterator().next().openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected boolean executeScriptLine(String line) {
        return this.executeCommand(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand(String line) {
        this.setShellStatus(ShellStatus.Status.PARSING);
        ExecutionStrategy executionStrategy = this.getExecutionStrategy();
        boolean flashedMessage = false;
        while (executionStrategy == null || !executionStrategy.isReadyForCommands()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (flashedMessage) continue;
            this.flash(Level.INFO, "Please wait - still loading", MY_SLOT);
            flashedMessage = true;
        }
        if (flashedMessage) {
            this.flash(Level.INFO, "", MY_SLOT);
        }
        ParseResult parseResult = null;
        try {
            if (!this.inBlockComment && line.contains("/*") && line.contains("*/")) {
                this.blockCommentBegin();
                String lhs = line.substring(0, line.lastIndexOf("/*"));
                if (line.contains("*/")) {
                    line = lhs + line.substring(line.lastIndexOf("*/") + 2);
                    this.blockCommentFinish();
                } else {
                    line = lhs;
                }
            }
            if (this.inBlockComment) {
                if (!line.contains("*/")) {
                    boolean lhs = true;
                    return lhs;
                }
                this.blockCommentFinish();
                line = line.substring(line.lastIndexOf("*/") + 2);
            }
            if (!this.inBlockComment && (line.trim().startsWith("//") || line.trim().startsWith("#"))) {
                line = "";
            }
            if ("".equals((line = line.replace('\t', ' ')).trim())) {
                this.setShellStatus(ShellStatus.Status.EXECUTION_SUCCESS);
                boolean lhs = true;
                return lhs;
            }
            parseResult = this.getParser().parse(line);
            if (parseResult == null) {
                boolean lhs = false;
                return lhs;
            }
            this.setShellStatus(ShellStatus.Status.EXECUTING);
            Object result = executionStrategy.execute(parseResult);
            this.setShellStatus(ShellStatus.Status.EXECUTION_RESULT_PROCESSING);
            if (result != null) {
                if (result instanceof ExitShellRequest) {
                    this.exitShellRequest = (ExitShellRequest)result;
                    executionStrategy.terminate();
                } else {
                    this.handleExecutionResult(result);
                }
            }
            this.logCommandIfRequired(line, true);
            this.setShellStatus(ShellStatus.Status.EXECUTION_SUCCESS, line, parseResult);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            this.setShellStatus(ShellStatus.Status.EXECUTION_FAILED, line, parseResult);
            try {
                this.logCommandIfRequired(line, false);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setShellStatus(ShellStatus.Status.USER_INPUT);
        }
    }

    protected void logCommandIfRequired(String line, boolean successful) {
        if (line.startsWith("script")) {
            this.logCommandToOutput((successful ? "// " : "// [failed] ") + line);
        } else {
            this.logCommandToOutput((successful ? "" : "// [failed] ") + line);
        }
    }

    protected void logCommandToOutput(String processedLine) {
    }

    @Override
    public void setPromptPath(String path) {
        shellPrompt = path == null || "".equals(path) ? ROO_PROMPT : path + " " + ROO_PROMPT;
    }

    @Override
    public void setPromptPath(String path, boolean overrideStyle) {
        this.setPromptPath(path);
    }

    @Override
    public ExitShellRequest getExitShellRequest() {
        return this.exitShellRequest;
    }

    @CliCommand(value={"//", ";"}, help="Inline comment markers (start of line only)")
    public void inlineComment() {
    }

    @CliCommand(value={"/*"}, help="Start of block comment")
    public void blockCommentBegin() {
        Assert.isTrue((!this.inBlockComment ? 1 : 0) != 0, (String)"Cannot open a new block comment when one already active");
        this.inBlockComment = true;
    }

    @CliCommand(value={"*/"}, help="End of block comment")
    public void blockCommentFinish() {
        Assert.isTrue((boolean)this.inBlockComment, (String)"Cannot close a block comment when it has not been opened");
        this.inBlockComment = false;
    }

    @CliCommand(value={"system properties"}, help="Shows the shell's properties")
    public String props() {
        TreeSet<String> data = new TreeSet<String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            data.add(entry.getKey() + " = " + entry.getValue());
        }
        return StringUtils.collectionToDelimitedString(data, (String)OsUtils.LINE_SEPARATOR) + OsUtils.LINE_SEPARATOR;
    }

    @CliCommand(value={"date"}, help="Displays the local date and time")
    public String date() {
        return DateFormat.getDateTimeInstance(0, 0, Locale.US).format(new Date());
    }

    public void flashCustom() throws Exception {
        this.flash(Level.FINE, "Hello world", "a");
        Thread.sleep(150L);
        this.flash(Level.FINE, "Short world", "a");
        Thread.sleep(150L);
        this.flash(Level.FINE, "Small", "a");
        Thread.sleep(150L);
        this.flash(Level.FINE, "Downloading xyz", "b");
        Thread.sleep(150L);
        this.flash(Level.FINE, "", "a");
        Thread.sleep(150L);
        this.flash(Level.FINE, "Downloaded xyz", "b");
        Thread.sleep(150L);
        this.flash(Level.FINE, "System online", "c");
        Thread.sleep(150L);
        this.flash(Level.FINE, "System ready", "c");
        Thread.sleep(150L);
        this.flash(Level.FINE, "System farewell", "c");
        Thread.sleep(150L);
        this.flash(Level.FINE, "", "c");
        Thread.sleep(150L);
        this.flash(Level.FINE, "", "b");
    }

    public String version(@CliOption(key={""}, help="Special version flags") String extra) {
        StringBuilder sb = new StringBuilder();
        if ("jaime".equals(extra)) {
            sb.append("               /\\ /l").append(OsUtils.LINE_SEPARATOR);
            sb.append("               ((.Y(!").append(OsUtils.LINE_SEPARATOR);
            sb.append("                \\ |/").append(OsUtils.LINE_SEPARATOR);
            sb.append("                /  6~6,").append(OsUtils.LINE_SEPARATOR);
            sb.append("                \\ _    +-.").append(OsUtils.LINE_SEPARATOR);
            sb.append("                 \\`-=--^-' \\").append(OsUtils.LINE_SEPARATOR);
            sb.append("                  \\   \\     |\\--------------------------+").append(OsUtils.LINE_SEPARATOR);
            sb.append("                 _/    \\    |  Thanks for loading Roo!  |").append(OsUtils.LINE_SEPARATOR);
            sb.append("                (  .    Y   +---------------------------+").append(OsUtils.LINE_SEPARATOR);
            sb.append("               /\"\\ `---^--v---.").append(OsUtils.LINE_SEPARATOR);
            sb.append("              / _ `---\"T~~\\/~\\/").append(OsUtils.LINE_SEPARATOR);
            sb.append("             / \" ~\\.      !").append(OsUtils.LINE_SEPARATOR);
            sb.append("       _    Y      Y.~~~ /'").append(OsUtils.LINE_SEPARATOR);
            sb.append("      Y^|   |      | Roo 7").append(OsUtils.LINE_SEPARATOR);
            sb.append("      | l   |     / .   /'").append(OsUtils.LINE_SEPARATOR);
            sb.append("      | `L  | Y .^/   ~T").append(OsUtils.LINE_SEPARATOR);
            sb.append("      |  l  ! | |/  | |               ____  ____  ____").append(OsUtils.LINE_SEPARATOR);
            sb.append("      | .`\\/' | Y   | !              / __ \\/ __ \\/ __ \\").append(OsUtils.LINE_SEPARATOR);
            sb.append("      l  \"~   j l   j L______       / /_/ / / / / / / /").append(OsUtils.LINE_SEPARATOR);
            sb.append("       \\,____{ __\"\" ~ __ ,\\_,\\_    / _, _/ /_/ / /_/ /").append(OsUtils.LINE_SEPARATOR);
            sb.append("    ~~~~~~~~~~~~~~~~~~~~~~~~~~~   /_/ |_|\\____/\\____/").append(" ").append(this.versionInfo()).append(OsUtils.LINE_SEPARATOR);
            return sb.toString();
        }
        sb.append("    ____  ____  ____  ").append(OsUtils.LINE_SEPARATOR);
        sb.append("   / __ \\/ __ \\/ __ \\ ").append(OsUtils.LINE_SEPARATOR);
        sb.append("  / /_/ / / / / / / / ").append(OsUtils.LINE_SEPARATOR);
        sb.append(" / _, _/ /_/ / /_/ /  ").append(OsUtils.LINE_SEPARATOR);
        sb.append("/_/ |_|\\____/\\____/   ").append(" ").append(this.versionInfo()).append(OsUtils.LINE_SEPARATOR);
        sb.append(OsUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    public String versionInfo() {
        return VersionUtils.versionInfo();
    }

    @Override
    public String getShellPrompt() {
        return shellPrompt;
    }

    @Override
    public File getHome() {
        String rooHome = this.getHomeAsString();
        File f = new File(rooHome);
        Assert.isTrue((!f.exists() || f.exists() && f.isDirectory() ? 1 : 0) != 0, (String)("Path '" + f.getAbsolutePath() + "' must be a directory, or it must not exist"));
        if (!f.exists()) {
            f.mkdirs();
        }
        Assert.isTrue((f.exists() && f.isDirectory() ? 1 : 0) != 0, (String)("Path '" + f.getAbsolutePath() + "' is not a directory; please specify roo.home system property correctly"));
        return f;
    }

    @Override
    public void flash(Level level, String message, String slot) {
        Assert.notNull((Object)level, (String)"Level is required for a flash message");
        Assert.notNull((Object)message, (String)"Message is required for a flash message");
        Assert.hasText((String)slot, (String)"Slot name must be specified for a flash message");
        if (!"".equals(message)) {
            this.logger.log(level, message);
        }
    }

    protected void handleExecutionResult(Object result) {
        if (result instanceof Iterable) {
            for (Object o : (Iterable)result) {
                this.logger.info(o.toString());
            }
        } else {
            this.logger.info(result.toString());
        }
    }
}

