/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
implements Converter<Enum> {
    @Override
    public Enum convertFromText(String value, Class<?> requiredType, String optionContext) {
        Class<?> enumClass = requiredType;
        return Enum.valueOf(enumClass, value);
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        Class<?> enumClass = requiredType;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            String candidate = enumValue.name();
            if (!"".equals(existingData) && !candidate.startsWith(existingData) && !existingData.startsWith(candidate) && !candidate.toUpperCase().startsWith(existingData.toUpperCase()) && !existingData.toUpperCase().startsWith(candidate.toUpperCase())) continue;
            completions.add(new Completion(candidate));
        }
        return true;
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return Enum.class.isAssignableFrom(requiredType);
    }
}

