/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.shell.core.InputReader;
import org.springframework.shell.core.command.CommandContext;
import org.springframework.shell.core.command.CommandExecutor;
import org.springframework.shell.core.command.CommandParser;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.ParsedInput;
import org.springframework.shell.test.ShellScreen;

public class ShellTestClient {
    private final CommandParser commandParser;
    private final CommandRegistry commandRegistry;
    private final CommandExecutor commandExecutor;

    public ShellTestClient(CommandParser commandParser, CommandRegistry commandRegistry) {
        this.commandParser = commandParser;
        this.commandRegistry = commandRegistry;
        this.commandExecutor = new CommandExecutor(commandRegistry);
    }

    public ShellScreen sendCommand(String input) throws Exception {
        StringWriter stringWriter = new StringWriter();
        ParsedInput parsedInput = this.commandParser.parse(input);
        PrintWriter outputWriter = new PrintWriter(stringWriter);
        InputReader inputReader = new InputReader(){};
        CommandContext commandContext = new CommandContext(parsedInput, this.commandRegistry, outputWriter, inputReader);
        this.commandExecutor.execute(commandContext);
        return ShellScreen.of(stringWriter.toString().lines().toList());
    }
}

