/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.shell.test.jediterm.terminal.StyledTextConsumer;
import org.springframework.shell.test.jediterm.terminal.TextStyle;
import org.springframework.shell.test.jediterm.terminal.model.CharBuffer;
import org.springframework.shell.test.jediterm.terminal.model.TerminalLine;

public class LinesBuffer {
    private static final Log log = LogFactory.getLog(LinesBuffer.class);
    public static final int DEFAULT_MAX_LINES_COUNT = 5000;
    private int myBufferMaxLinesCount = 5000;
    private ArrayList<TerminalLine> myLines = new ArrayList();

    public LinesBuffer() {
    }

    public LinesBuffer(int bufferMaxLinesCount) {
        this.myBufferMaxLinesCount = bufferMaxLinesCount;
    }

    public synchronized String getLines() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TerminalLine line : this.myLines) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(line.getText());
            first = false;
        }
        return sb.toString();
    }

    public synchronized void addNewLine(TextStyle style, CharBuffer characters) {
        this.addNewLine(new TerminalLine.TextEntry(style, characters));
    }

    private synchronized void addNewLine(TerminalLine.TextEntry entry) {
        this.addLine(new TerminalLine(entry));
    }

    private synchronized void addLine(TerminalLine line) {
        if (this.myBufferMaxLinesCount > 0 && this.myLines.size() >= this.myBufferMaxLinesCount) {
            this.removeTopLines(1);
        }
        this.myLines.add(line);
    }

    public synchronized int getLineCount() {
        return this.myLines.size();
    }

    public synchronized void removeTopLines(int count) {
        this.myLines = count >= this.myLines.size() ? new ArrayList() : new ArrayList<TerminalLine>(this.myLines.subList(count, this.myLines.size()));
    }

    public String getLineText(int row) {
        TerminalLine line = this.getLine(row);
        return line.getText();
    }

    public synchronized void insertLines(int y, int count, int lastLine, TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer();
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer();
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        for (int i = 0; i < count; ++i) {
            head.addNewLine(filler);
        }
        head.moveBottomLinesTo(head.getLineCount(), this);
        this.removeBottomLines(count);
        tail.moveTopLinesTo(tail.getLineCount(), this);
    }

    public synchronized LinesBuffer deleteLines(int y, int count, int lastLine, TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer();
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer();
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        int toRemove = Math.min(count, this.getLineCount());
        LinesBuffer removed = new LinesBuffer();
        this.moveTopLinesTo(toRemove, removed);
        head.moveBottomLinesTo(head.getLineCount(), this);
        for (int i = 0; i < toRemove; ++i) {
            this.addNewLine(filler);
        }
        tail.moveTopLinesTo(tail.getLineCount(), this);
        return removed;
    }

    public synchronized void writeString(int x, int y, CharBuffer str, TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.writeString(x, str, style);
    }

    public synchronized void clearLines(int startRow, int endRow, TerminalLine.TextEntry filler) {
        for (int i = startRow; i <= endRow; ++i) {
            this.getLine(i).clear(filler);
        }
    }

    public synchronized void clearAll() {
        this.myLines.clear();
    }

    public synchronized void deleteCharacters(int x, int y, int count, TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.deleteCharacters(x, count, style);
    }

    public synchronized void insertBlankCharacters(int x, int y, int count, int maxLen, TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.insertBlankCharacters(x, count, maxLen, style);
    }

    public synchronized void clearArea(int leftX, int topY, int rightX, int bottomY, TextStyle style) {
        for (int y = topY; y < bottomY; ++y) {
            TerminalLine line = this.getLine(y);
            line.clearArea(leftX, rightX, style);
        }
    }

    public synchronized void processLines(int yStart, int yCount, StyledTextConsumer consumer) {
        this.processLines(yStart, yCount, consumer, -this.getLineCount());
    }

    public synchronized void processLines(int firstLine, int count, StyledTextConsumer consumer, int startRow) {
        if (firstLine < 0) {
            throw new IllegalArgumentException("firstLine=" + firstLine + ", should be >0");
        }
        for (int y = firstLine; y < Math.min(firstLine + count, this.myLines.size()); ++y) {
            this.myLines.get(y).process(y, consumer, startRow);
        }
    }

    public synchronized void moveTopLinesTo(int count, LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLines(this.myLines.subList(0, count));
        this.removeTopLines(count);
    }

    public synchronized void addLines(List<TerminalLine> lines) {
        if (this.myBufferMaxLinesCount > 0) {
            if (lines.size() >= this.myBufferMaxLinesCount) {
                int index = lines.size() - this.myBufferMaxLinesCount;
                this.myLines = new ArrayList<TerminalLine>(lines.subList(index, lines.size()));
                return;
            }
            int count = this.myLines.size() + lines.size();
            if (count >= this.myBufferMaxLinesCount) {
                this.removeTopLines(count - this.myBufferMaxLinesCount);
            }
        }
        this.myLines.addAll(lines);
    }

    public synchronized TerminalLine getLine(int row) {
        if (row < 0) {
            log.error((Object)("Negative line number: " + row));
            return TerminalLine.createEmpty();
        }
        for (int i = this.getLineCount(); i <= row; ++i) {
            this.addLine(TerminalLine.createEmpty());
        }
        return this.myLines.get(row);
    }

    public synchronized void moveBottomLinesTo(int count, LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLinesFirst(this.myLines.subList(this.getLineCount() - count, this.getLineCount()));
        this.removeBottomLines(count);
    }

    private synchronized void addLinesFirst(List<TerminalLine> lines) {
        ArrayList<TerminalLine> list = new ArrayList<TerminalLine>(lines);
        list.addAll(this.myLines);
        this.myLines = new ArrayList<TerminalLine>(list);
    }

    private synchronized void removeBottomLines(int count) {
        this.myLines = new ArrayList<TerminalLine>(this.myLines.subList(0, this.getLineCount() - count));
    }

    public int removeBottomEmptyLines(int ind, int maxCount) {
        int i = 0;
        while (maxCount - i > 0 && (ind >= this.myLines.size() || this.myLines.get(ind).isNul())) {
            if (ind < this.myLines.size()) {
                this.myLines.remove(ind);
            }
            --ind;
            ++i;
        }
        return i;
    }

    synchronized int findLineIndex(TerminalLine line) {
        return this.myLines.indexOf(line);
    }

    public synchronized void clearTypeAheadPredictions() {
        for (TerminalLine line : this.myLines) {
            line.myTypeAheadLine = null;
        }
    }
}

