/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.shell.test.jediterm.terminal.RequestOrigin;
import org.springframework.shell.test.jediterm.terminal.Terminal;
import org.springframework.shell.test.jediterm.terminal.TerminalDataStream;
import org.springframework.shell.test.jediterm.terminal.TerminalOutputStream;
import org.springframework.shell.test.jediterm.terminal.TtyConnector;
import org.springframework.shell.test.jediterm.terminal.emulator.Emulator;
import org.springframework.shell.test.jediterm.terminal.emulator.JediEmulator;

public class TerminalStarter
implements TerminalOutputStream {
    private static final Log log = LogFactory.getLog(TerminalStarter.class);
    private final Emulator myEmulator;
    private final Terminal myTerminal;
    private final TtyConnector myTtyConnector;
    private final ScheduledExecutorService myEmulatorExecutor = Executors.newSingleThreadScheduledExecutor();

    public TerminalStarter(Terminal terminal, TtyConnector ttyConnector, TerminalDataStream dataStream) {
        this.myTtyConnector = ttyConnector;
        this.myTerminal = terminal;
        this.myTerminal.setTerminalOutput(this);
        this.myEmulator = this.createEmulator(dataStream, terminal);
    }

    protected JediEmulator createEmulator(TerminalDataStream dataStream, Terminal terminal) {
        return new JediEmulator(dataStream, terminal);
    }

    private void execute(Runnable runnable) {
        if (!this.myEmulatorExecutor.isShutdown()) {
            this.myEmulatorExecutor.execute(runnable);
        }
    }

    public void start() {
        try {
            while (!Thread.currentThread().isInterrupted() && this.myEmulator.hasNext()) {
                this.myEmulator.next();
            }
        }
        catch (InterruptedIOException e) {
            log.info((Object)"Terminal exiting");
        }
        catch (Exception e) {
            if (!this.myTtyConnector.isConnected()) {
                this.myTerminal.disconnected();
                return;
            }
            log.error((Object)"Caught exception in terminal thread", (Throwable)e);
        }
    }

    public void postResize(int width, int height, RequestOrigin origin) {
        this.execute(() -> TerminalStarter.resize(this.myEmulator, this.myTerminal, this.myTtyConnector, width, height, origin, (millisDelay, runnable) -> this.myEmulatorExecutor.schedule((Runnable)runnable, (long)millisDelay, TimeUnit.MILLISECONDS)));
    }

    public static void resize(Emulator emulator, Terminal terminal, TtyConnector ttyConnector, int width, int height, RequestOrigin origin, BiConsumer<Long, Runnable> taskScheduler) {
        CompletableFuture<?> promptUpdated = ((JediEmulator)emulator).getPromptUpdatedAfterResizeFuture(taskScheduler);
        terminal.resize(width, height, origin, promptUpdated);
        ttyConnector.resize(width, height);
    }

    @Override
    public void sendBytes(byte[] bytes) {
        this.sendBytes(bytes, false);
    }

    @Override
    public void sendBytes(byte[] bytes, boolean userInput) {
        this.execute(() -> {
            try {
                this.myTtyConnector.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void sendString(String string) {
        this.sendString(string, false);
    }

    @Override
    public void sendString(String string, boolean userInput) {
        this.execute(() -> {
            try {
                this.myTtyConnector.write(string);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void close() {
        this.execute(() -> {
            try {
                this.myTtyConnector.close();
            }
            catch (Exception e) {
                log.error((Object)"Error closing terminal", (Throwable)e);
            }
            finally {
                this.myEmulatorExecutor.shutdown();
            }
        });
    }
}

