/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test;

import org.springframework.shell.test.ShellWriteSequence;

class DefaultShellWriteSequence
implements ShellWriteSequence {
    private final StringBuilder buf = new StringBuilder();

    DefaultShellWriteSequence() {
    }

    @Override
    public ShellWriteSequence carriageReturn() {
        this.buf.append("\r");
        return this;
    }

    @Override
    public ShellWriteSequence clearScreen() {
        this.buf.append("\u001b[H\u001b[2J");
        return this;
    }

    @Override
    public ShellWriteSequence ctrl(char c) {
        this.buf.append((char)(c & 0x1F));
        return this;
    }

    @Override
    public ShellWriteSequence command(String command) {
        this.text(command);
        return this.carriageReturn();
    }

    @Override
    public ShellWriteSequence cr() {
        return this.carriageReturn();
    }

    @Override
    public ShellWriteSequence keyUp() {
        this.buf.append("\u001b[A");
        return this;
    }

    @Override
    public ShellWriteSequence keyDown() {
        this.buf.append("\u001b[B");
        return this;
    }

    @Override
    public ShellWriteSequence keyLeft() {
        this.buf.append("\u001b[D");
        return this;
    }

    @Override
    public ShellWriteSequence keyRight() {
        this.buf.append("\u001b[C");
        return this;
    }

    @Override
    public ShellWriteSequence text(String text) {
        this.buf.append(text);
        return this;
    }

    @Override
    public ShellWriteSequence space() {
        return this.text(" ");
    }

    @Override
    public String build() {
        return this.buf.toString();
    }
}

