/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.springframework.shell.core.ConsoleInputProvider;
import org.springframework.shell.core.NonInteractiveShellRunner;
import org.springframework.shell.core.ShellRunner;
import org.springframework.shell.core.SystemShellRunner;
import org.springframework.shell.core.command.CommandParser;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.DefaultCommandParser;
import org.springframework.shell.jline.JLineInputProvider;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.test.ShellScreen;
import org.springframework.shell.test.ShellWriteSequence;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalSession;

public interface ShellTestClient
extends Closeable {
    public InteractiveShellSession interactive();

    public NonInteractiveShellSession nonInteractive(String ... var1);

    public ShellScreen screen();

    public static Builder builder(TerminalSession terminalSession, PromptProvider promptProvider, LineReader lineReader, Terminal terminal, Parser parser) {
        return new Builder(terminalSession, promptProvider, lineReader, terminal, parser);
    }

    public static class Builder {
        private TerminalSession terminalSession;
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private Terminal terminal;
        private Parser parser;

        Builder(TerminalSession terminalSession, PromptProvider promptProvider, LineReader lineReader, Terminal terminal, Parser parser) {
            this.terminalSession = terminalSession;
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.terminal = terminal;
            this.parser = parser;
        }

        public ShellTestClient build() {
            return new DefaultShellClient(this.terminalSession, this.promptProvider, this.lineReader, this.terminal, this.parser);
        }
    }

    public static class ShellRunnerTask
    implements Runnable {
        private static final Log log = LogFactory.getLog(ShellRunnerTask.class);
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;

        ShellRunnerTask(BlockingQueue<ShellRunnerTaskData> blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        @Override
        public void run() {
            log.trace((Object)"ShellRunnerTask start");
            try {
                Thread.currentThread().setName("ShellRunnerTask");
                while (true) {
                    ShellRunnerTaskData data = this.blockingQueue.take();
                    if (data.runner == null) {
                        return;
                    }
                    try {
                        log.trace((Object)("Running " + String.valueOf(data.runner())));
                        data.state().set(-1);
                        data.runner().run(data.args());
                        data.state().set(0);
                        log.trace((Object)("Running done " + String.valueOf(data.runner())));
                    }
                    catch (Exception e) {
                        data.state().set(1);
                        log.trace((Object)"ShellRunnerThread ex", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.trace((Object)"ShellRunnerTask end");
                return;
            }
        }
    }

    public record ShellRunnerTaskData(ShellRunner runner, String[] args, AtomicInteger state) {
    }

    public static class DefaultNonInteractiveShellSession
    implements NonInteractiveShellSession {
        private String[] args;
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;
        private TerminalSession terminalSession;
        private Terminal terminal;
        private Parser parser;
        private final AtomicInteger state = new AtomicInteger(-2);

        public DefaultNonInteractiveShellSession(Parser parser, String[] args, BlockingQueue<ShellRunnerTaskData> blockingQueue, TerminalSession terminalSession, Terminal terminal) {
            this.args = args;
            this.blockingQueue = blockingQueue;
            this.terminalSession = terminalSession;
            this.terminal = terminal;
            this.parser = parser;
        }

        @Override
        public ShellWriteSequence writeSequence() {
            return ShellWriteSequence.of(this.terminal);
        }

        @Override
        public NonInteractiveShellSession write(String text) {
            this.terminalSession.getTerminalStarter().sendString(text);
            return this;
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public NonInteractiveShellSession run() {
            NonInteractiveShellRunner runner = new NonInteractiveShellRunner((CommandParser)new DefaultCommandParser(), new CommandRegistry());
            this.blockingQueue.add(new ShellRunnerTaskData((ShellRunner)runner, this.args, this.state));
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.state.get() >= 0;
        }
    }

    public static class DefaultInteractiveShellSession
    implements InteractiveShellSession {
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;
        private TerminalSession terminalSession;
        private Terminal terminal;
        private final AtomicInteger state = new AtomicInteger(-2);

        public DefaultInteractiveShellSession(PromptProvider promptProvider, LineReader lineReader, BlockingQueue<ShellRunnerTaskData> blockingQueue, TerminalSession terminalSession, Terminal terminal) {
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.blockingQueue = blockingQueue;
            this.terminalSession = terminalSession;
            this.terminal = terminal;
        }

        @Override
        public ShellWriteSequence writeSequence() {
            return ShellWriteSequence.of(this.terminal);
        }

        @Override
        public InteractiveShellSession write(String text) {
            this.terminalSession.getTerminalStarter().sendString(text);
            return this;
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public InteractiveShellSession run() {
            JLineInputProvider inputProvider = new JLineInputProvider(this.lineReader);
            inputProvider.setPromptProvider(this.promptProvider);
            SystemShellRunner runner = new SystemShellRunner(new ConsoleInputProvider(), (CommandParser)new DefaultCommandParser(), new CommandRegistry());
            this.blockingQueue.add(new ShellRunnerTaskData((ShellRunner)runner, new String[0], this.state));
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.state.get() >= 0;
        }
    }

    public static class DefaultShellClient
    implements ShellTestClient {
        private static final Log log = LogFactory.getLog(DefaultShellClient.class);
        private TerminalSession terminalSession;
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private Thread runnerThread;
        private Terminal terminal;
        private Parser parser;
        private final BlockingQueue<ShellRunnerTaskData> blockingQueue = new LinkedBlockingDeque<ShellRunnerTaskData>(10);

        DefaultShellClient(TerminalSession terminalSession, PromptProvider promptProvider, LineReader lineReader, Terminal terminal, Parser parser) {
            this.terminalSession = terminalSession;
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.terminal = terminal;
            this.parser = parser;
        }

        @Override
        public InteractiveShellSession interactive() {
            this.terminalSession.start();
            if (this.runnerThread == null) {
                this.runnerThread = new Thread(new ShellRunnerTask(this.blockingQueue));
                this.runnerThread.start();
            }
            return new DefaultInteractiveShellSession(this.promptProvider, this.lineReader, this.blockingQueue, this.terminalSession, this.terminal);
        }

        @Override
        public NonInteractiveShellSession nonInteractive(String ... args) {
            this.terminalSession.start();
            if (this.runnerThread == null) {
                this.runnerThread = new Thread(new ShellRunnerTask(this.blockingQueue));
                this.runnerThread.start();
            }
            return new DefaultNonInteractiveShellSession(this.parser, args, this.blockingQueue, this.terminalSession, this.terminal);
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public void close() throws IOException {
            log.debug((Object)"Closing ShellClient");
            if (this.runnerThread != null) {
                this.runnerThread.interrupt();
            }
            this.runnerThread = null;
            this.terminalSession.close();
        }
    }

    public static interface NonInteractiveShellSession
    extends BaseShellSession<NonInteractiveShellSession> {
    }

    public static interface InteractiveShellSession
    extends BaseShellSession<InteractiveShellSession> {
    }

    public static interface BaseShellSession<T extends BaseShellSession<T>> {
        public ShellWriteSequence writeSequence();

        public ShellScreen screen();

        public T write(String var1);

        public T run();

        public boolean isComplete();
    }
}

