/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jline.utils.AttributedString;
import org.springframework.core.io.Resource;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.standard.AbstractShellComponent;
import org.springframework.shell.standard.CommandValueProvider;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.commands.CommandInfoModel;
import org.springframework.shell.standard.commands.GroupsInfoModel;
import org.springframework.shell.style.TemplateExecutor;
import org.springframework.util.FileCopyUtils;

@ShellComponent
public class Help
extends AbstractShellComponent {
    private boolean showGroups = true;
    private TemplateExecutor templateExecutor;
    private String commandTemplate;
    private String commandsTemplate;

    public Help(TemplateExecutor templateExecutor) {
        this.templateExecutor = templateExecutor;
    }

    @ShellMethod(value="Display help about available commands")
    public AttributedString help(@ShellOption(defaultValue="__NULL__", valueProvider=CommandValueProvider.class, value={"-C", "--command"}, help="The command to obtain help for.", arity=0x7FFFFFFF) String command) throws IOException {
        if (command == null) {
            return this.renderCommands();
        }
        return this.renderCommand(command);
    }

    public void setCommandTemplate(String commandTemplate) {
        this.commandTemplate = commandTemplate;
    }

    public void setCommandsTemplate(String commandsTemplate) {
        this.commandsTemplate = commandsTemplate;
    }

    public void setShowGroups(boolean showGroups) {
        this.showGroups = showGroups;
    }

    private AttributedString renderCommands() {
        Map registrations = this.getCommandCatalog().getRegistrations();
        boolean isStg = this.commandTemplate.endsWith(".stg");
        HashMap<String, GroupsInfoModel> model = new HashMap<String, GroupsInfoModel>();
        model.put("model", GroupsInfoModel.of(this.showGroups, registrations));
        String templateResource = Help.resourceAsString(this.getResourceLoader().getResource(this.commandsTemplate));
        return isStg ? this.templateExecutor.renderGroup(templateResource, model) : this.templateExecutor.render(templateResource, model);
    }

    private AttributedString renderCommand(String command) {
        Map registrations = this.getCommandCatalog().getRegistrations();
        CommandRegistration registration = (CommandRegistration)registrations.get(command);
        if (registration == null) {
            throw new IllegalArgumentException("Unknown command '" + command + "'");
        }
        boolean isStg = this.commandTemplate.endsWith(".stg");
        HashMap<String, CommandInfoModel> model = new HashMap<String, CommandInfoModel>();
        model.put("model", CommandInfoModel.of(command, registration));
        String templateResource = Help.resourceAsString(this.getResourceLoader().getResource(this.commandTemplate));
        return isStg ? this.templateExecutor.renderGroup(templateResource, model) : this.templateExecutor.render(templateResource, model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resourceAsString(Resource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static interface Command {
    }
}

