/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.flow;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.MultiItemSelector;
import org.springframework.shell.jline.tui.component.flow.BaseInput;
import org.springframework.shell.jline.tui.component.flow.ComponentFlow;
import org.springframework.shell.jline.tui.component.flow.MultiItemSelectorSpec;
import org.springframework.shell.jline.tui.component.flow.ResultMode;
import org.springframework.shell.jline.tui.component.flow.SelectItem;
import org.springframework.shell.jline.tui.component.support.SelectorItem;

public abstract class BaseMultiItemSelector
extends BaseInput<MultiItemSelectorSpec>
implements MultiItemSelectorSpec {
    private @Nullable String name;
    private List<String> resultValues = new ArrayList<String>();
    private @Nullable ResultMode resultMode;
    private List<SelectItem> selectItems = new ArrayList<SelectItem>();
    private @Nullable Comparator<SelectorItem<String>> comparator;
    private @Nullable Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> renderer;
    private @Nullable Integer maxItems;
    private List<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>> preHandlers = new ArrayList<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>>();
    private List<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>> postHandlers = new ArrayList<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>>();
    private boolean storeResult = true;
    private @Nullable String templateLocation;
    private @Nullable Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, String> next;

    public BaseMultiItemSelector(ComponentFlow.BaseBuilder builder, String id) {
        super(builder, id);
    }

    @Override
    public MultiItemSelectorSpec name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MultiItemSelectorSpec resultValues(List<String> resultValues) {
        this.resultValues.addAll(resultValues);
        return this;
    }

    @Override
    public MultiItemSelectorSpec resultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
        return this;
    }

    @Override
    public MultiItemSelectorSpec selectItems(List<SelectItem> selectItems) {
        this.selectItems = selectItems;
        return this;
    }

    @Override
    public MultiItemSelectorSpec sort(Comparator<SelectorItem<String>> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public MultiItemSelectorSpec renderer(Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public MultiItemSelectorSpec template(String location) {
        this.templateLocation = location;
        return this;
    }

    @Override
    public MultiItemSelectorSpec max(int max) {
        this.maxItems = max;
        return this;
    }

    @Override
    public MultiItemSelectorSpec preHandler(Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>> handler) {
        this.preHandlers.add(handler);
        return this;
    }

    @Override
    public MultiItemSelectorSpec postHandler(Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>> handler) {
        this.postHandlers.add(handler);
        return this;
    }

    @Override
    public MultiItemSelectorSpec storeResult(boolean store) {
        this.storeResult = store;
        return this;
    }

    @Override
    public MultiItemSelectorSpec next(Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, String> next) {
        this.next = next;
        return this;
    }

    @Override
    public ComponentFlow.Builder and() {
        this.getBuilder().addMultiItemSelector(this);
        return this.getBuilder();
    }

    @Override
    public MultiItemSelectorSpec getThis() {
        return this;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public List<String> getResultValues() {
        return this.resultValues;
    }

    public @Nullable ResultMode getResultMode() {
        return this.resultMode;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public @Nullable Comparator<SelectorItem<String>> getComparator() {
        return this.comparator;
    }

    public @Nullable Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> getRenderer() {
        return this.renderer;
    }

    public @Nullable String getTemplateLocation() {
        return this.templateLocation;
    }

    public @Nullable Integer getMaxItems() {
        return this.maxItems;
    }

    public List<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>> getPreHandlers() {
        return this.preHandlers;
    }

    public List<Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>>> getPostHandlers() {
        return this.postHandlers;
    }

    public boolean isStoreResult() {
        return this.storeResult;
    }

    public @Nullable Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, String> getNext() {
        return this.next;
    }
}

