/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;

public class JLineRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ProxyHints proxy = hints.proxies();
        ReflectionHints reflection = hints.reflection();
        ReflectionHints jni = hints.jni();
        this.registerProxies(proxy, "org.jline.terminal.impl.jna.win.Kernel32", "org.jline.terminal.impl.jna.linux.CLibrary");
        this.registerForMostReflection(reflection, "org.jline.terminal.impl.jna.win.Kernel32$CHAR_INFO", "org.jline.terminal.impl.jna.win.Kernel32$CONSOLE_CURSOR_INFO", "org.jline.terminal.impl.jna.win.Kernel32$CONSOLE_SCREEN_BUFFER_INFO", "org.jline.terminal.impl.jna.win.Kernel32$COORD", "org.jline.terminal.impl.jna.win.Kernel32$INPUT_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$INPUT_RECORD$EventUnion", "org.jline.terminal.impl.jna.win.Kernel32$KEY_EVENT_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$MOUSE_EVENT_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$WINDOW_BUFFER_SIZE_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$MENU_EVENT_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$FOCUS_EVENT_RECORD", "org.jline.terminal.impl.jna.win.Kernel32$SMALL_RECT", "org.jline.terminal.impl.jna.win.Kernel32$UnionChar");
        this.registerForMostReflection(reflection, "org.jline.terminal.impl.jna.linux.CLibrary$termios", "org.jline.terminal.impl.jna.linux.CLibrary$winsize");
        this.registerJni(jni);
    }

    private void registerProxies(ProxyHints proxy, String ... classNames) {
        this.typeReferences(classNames).forEach(tr -> proxy.registerJdkProxy(jdkProxyHint -> jdkProxyHint.proxiedInterfaces(new TypeReference[]{tr})));
    }

    private List<TypeReference> typeReferences(String ... classNames) {
        return Stream.of(classNames).map(TypeReference::of).collect(Collectors.toList());
    }

    private void registerForMostReflection(ReflectionHints reflection, String ... classNames) {
        reflection.registerTypes(this.typeReferences(classNames), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_CLASSES, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_CLASSES, MemberCategory.PUBLIC_FIELDS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
    }

    private void registerJni(ReflectionHints jni) {
        TypeReference reachableType = TypeReference.of((String)"org.jline.terminal.impl.jna.win.Kernel32");
        this.registerForJni(jni, reachableType, "com.sun.jna.Callback", Methods.of(new Method[0]), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.CallbackReference", Methods.of(Method.of("getCallback", "java.lang.Class", "com.sun.jna.Pointer", "boolean"), Method.of("getFunctionPointer", "com.sun.jna.Callback", "boolean"), Method.of("getNativeString", "java.lang.Object", "boolean"), Method.of("initializeThread", "com.sun.jna.Callback", "com.sun.jna.CallbackReference$AttachOptions")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.CallbackReference$AttachOptions", Methods.of(new Method[0]), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.FromNativeConverter", Methods.of(Method.of("nativeType", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.IntegerType", Methods.of(new Method[0]), Fields.of("value"));
        this.registerForJni(jni, reachableType, "com.sun.jna.JNIEnv", Methods.of(new Method[0]), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.Native", Methods.of(Method.of("dispose", new String[0]), Method.of("fromNative", "com.sun.jna.FromNativeConverter", "java.lang.Object", "java.lang.reflect.Method"), Method.of("fromNative", "java.lang.Class", "java.lang.Object"), Method.of("fromNative", "java.lang.reflect.Method", "java.lang.Object"), Method.of("nativeType", "java.lang.Class"), Method.of("toNative", "com.sun.jna.ToNativeConverter", "java.lang.Object")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.Native$ffi_callback", Methods.of(Method.of("invoke", "long", "long", "long")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.NativeMapped", Methods.of(Method.of("toNative", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.Pointer", Methods.of(Method.of("<init>", "long")), Fields.of("peer"));
        this.registerForJni(jni, reachableType, "com.sun.jna.PointerType", Methods.of(new Method[0]), Fields.of("pointer"));
        this.registerForJni(jni, reachableType, "com.sun.jna.Structure", Methods.of(Method.of("autoRead", new String[0]), Method.of("autoWrite", new String[0]), Method.of("getTypeInfo", new String[0]), Method.of("newInstance", "java.lang.Class", "long")), Fields.of("memory", "typeInfo"));
        this.registerForJni(jni, reachableType, "com.sun.jna.Structure$ByValue", Methods.of(new Method[0]), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "com.sun.jna.Structure$FFIType$FFITypes", Methods.of(new Method[0]), Fields.of("ffi_type_double", "ffi_type_float", "ffi_type_longdouble", "ffi_type_pointer", "ffi_type_sint16", "ffi_type_sint32", "ffi_type_sint64", "ffi_type_sint8", "ffi_type_uint16", "ffi_type_uint32", "ffi_type_uint64", "ffi_type_uint8", "ffi_type_void"));
        this.registerForJni(jni, reachableType, "com.sun.jna.WString", Methods.of(Method.of("<init>", "java.lang.String")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.Boolean", Methods.of(Method.of("<init>", "boolean")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Byte", Methods.of(Method.of("<init>", "byte")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Character", Methods.of(Method.of("<init>", "char")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Class", Methods.of(Method.of("getComponentType", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.Double", Methods.of(Method.of("<init>", "double")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Float", Methods.of(Method.of("<init>", "float")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Integer", Methods.of(Method.of("<init>", "int")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Long", Methods.of(Method.of("<init>", "long")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.Object", Methods.of(Method.of("toString", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.Short", Methods.of(Method.of("<init>", "short")), Fields.of("TYPE", "value"));
        this.registerForJni(jni, reachableType, "java.lang.String", Methods.of(Method.of("<init>", "byte[]"), Method.of("<init>", "byte[]", "java.lang.String"), Method.of("getBytes", new String[0]), Method.of("getBytes", "java.lang.String"), Method.of("toCharArray", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.System", Methods.of(Method.of("getProperty", "java.lang.String")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.UnsatisfiedLinkError", Methods.of(Method.of("<init>", "java.lang.String")), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.lang.Void", Methods.of(new Method[0]), Fields.of("TYPE"));
        this.registerForJni(jni, reachableType, "java.lang.reflect.Method", Methods.of(Method.of("getParameterTypes", new String[0]), Method.of("getReturnType", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.Buffer", Methods.of(Method.of("position", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.ByteBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.CharBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.DoubleBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.FloatBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.IntBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.LongBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
        this.registerForJni(jni, reachableType, "java.nio.ShortBuffer", Methods.of(Method.of("array", new String[0]), Method.of("arrayOffset", new String[0])), Fields.of(new String[0]));
    }

    private void registerForJni(ReflectionHints jni, TypeReference reachableType, String type, Methods methods, Fields fields) {
        jni.registerType(TypeReference.of((String)type), hint -> {
            hint.onReachableType(reachableType);
            methods.withHints((TypeHint.Builder)hint);
            fields.withHints((TypeHint.Builder)hint);
        });
    }

    record Method(String name, String[] parameterTypes) {
        static Method of(String name, String ... parameterTypes) {
            return new Method(name, parameterTypes);
        }

        private List<TypeReference> asTypeReferences() {
            return Stream.of(this.parameterTypes).map(TypeReference::of).collect(Collectors.toList());
        }

        void withHints(TypeHint.Builder hint) {
            hint.withMethod(this.name, this.asTypeReferences(), ExecutableMode.INVOKE);
        }
    }

    record Methods(Method[] methods) {
        static Methods of(Method ... methods) {
            return new Methods(methods);
        }

        void withHints(TypeHint.Builder hint) {
            Stream.of(this.methods()).forEach(m -> m.withHints(hint));
        }
    }

    record Fields(String[] names) {
        static Fields of(String ... names) {
            return new Fields(names);
        }

        void withHints(TypeHint.Builder hint) {
            Stream.of(this.names()).forEach(f -> hint.withField(f));
        }
    }
}

