/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.core.command.Command;
import org.springframework.shell.core.command.CommandOption;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.completion.CompletionContext;
import org.springframework.shell.core.command.completion.CompletionProposal;
import org.springframework.shell.core.command.completion.CompletionProvider;
import org.springframework.shell.core.utils.Utils;
import org.springframework.util.StringUtils;

public class CommandCompleter
implements Completer {
    private final CommandRegistry commandRegistry;

    public CommandCompleter(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Command commandByName = this.findCommandByWords(line.words());
        if (commandByName != null) {
            List options = commandByName.getOptions();
            CommandOption commandOption = this.findOptionByWords(line.words(), options);
            if (commandOption == null) {
                for (CommandOption option : options) {
                    boolean present = this.isOptionPresent(line, option);
                    if (StringUtils.hasLength((String)option.longName()) && !present) {
                        candidates.add(new Candidate("--" + option.longName()));
                    }
                    if (option.shortName() == ' ' || present) continue;
                    candidates.add(new Candidate("-" + option.shortName()));
                }
            }
            CompletionProvider completionProvider = commandByName.getCompletionProvider();
            CompletionContext context = new CompletionContext(line.words(), line.wordIndex(), line.wordCursor(), commandByName, commandOption);
            List proposals = (List)completionProvider.apply((Object)context);
            for (CompletionProposal proposal : proposals) {
                candidates.add(new Candidate(proposal.value(), proposal.displayText(), proposal.category(), proposal.description(), null, null, proposal.complete(), 0));
            }
        } else {
            this.commandRegistry.getCommandsByPrefix(line.line()).stream().map(command -> this.toCommandCandidates((Command)command, line.words())).flatMap(Collection::stream).sorted(Candidate::compareTo).forEach(candidates::add);
        }
    }

    private List<Candidate> toCommandCandidates(Command command, List<String> words) {
        String prefix = words.size() > 1 ? String.join((CharSequence)" ", words.subList(0, words.size() - 1)) : "";
        return this.getCommandNames(command).filter(name -> name.startsWith((String)words.get(0))).filter(name -> name.startsWith(prefix)).map(cmd -> new Candidate(cmd.substring(prefix.length()).trim(), cmd + ": " + command.getDescription(), command.getGroup(), null, null, null, !Utils.QUIT_COMMAND.equals(command))).toList();
    }

    private boolean isOptionPresent(ParsedLine line, CommandOption option) {
        return option.longName() != null && (line.line().contains(" --" + option.longName() + " ") || line.line().contains(" --" + option.longName() + "=")) || option.shortName() != ' ' && (line.line().contains(" -" + option.shortName() + " ") || line.line().contains(" -" + option.shortName() + "="));
    }

    private @Nullable Command findCommandByWords(List<String> words) {
        StringBuilder commandName = new StringBuilder();
        for (String word : words) {
            if (word.startsWith("-")) break;
            commandName.append(word).append(" ");
        }
        Command command = this.commandRegistry.getCommandByName(commandName.toString().trim());
        if (command != null && this.getCommandNames(command).toList().contains(String.join((CharSequence)" ", words))) {
            command = null;
        }
        return command;
    }

    private @Nullable CommandOption findOptionByWords(List<String> words, List<CommandOption> options) {
        CommandOption option;
        ArrayList<String> reversed = new ArrayList<String>(words);
        Collections.reverse(reversed);
        if (((String)reversed.get(0)).isEmpty()) {
            option = this.findOption(options, o -> o.isOptionEqual((String)reversed.get(1)));
        } else {
            option = this.findOption(options, o -> CommandCompleter.isOptionStartWith((String)reversed.get(0), o));
            if (option == null) {
                option = this.findOption(options, o -> o.isOptionEqual((String)reversed.get(1)));
            }
        }
        return option;
    }

    private @Nullable CommandOption findOption(List<CommandOption> options, Predicate<CommandOption> optionFilter) {
        return options.stream().filter(optionFilter).findFirst().orElse(null);
    }

    private static boolean isOptionStartWith(String optionName, CommandOption option) {
        return StringUtils.hasLength((String)option.longName()) && optionName.startsWith("--" + option.longName() + "=") || option.shortName() != ' ' && optionName.startsWith("-" + option.shortName() + "=");
    }

    private Stream<String> getCommandNames(Command command) {
        return Stream.concat(Stream.of(command.getName()), command.getAliases().stream());
    }
}

