/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.support.search;

import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.support.search.SearchMatchAlgorithm;

public interface SearchMatchResult {
    public int getStart();

    public int getEnd();

    public int getScore();

    public int[] getPositions();

    public @Nullable SearchMatchAlgorithm getAlgorithm();

    public static SearchMatchResult of(int start, int end, int score, int[] positions, @Nullable SearchMatchAlgorithm algo) {
        return new DefaultResult(start, end, score, positions, algo);
    }

    public static SearchMatchResult ofZeros() {
        return SearchMatchResult.of(0, 0, 0, new int[0], null);
    }

    public static SearchMatchResult ofMinus() {
        return SearchMatchResult.of(-1, -1, 0, new int[0], null);
    }

    public static class DefaultResult
    implements SearchMatchResult {
        int start;
        int end;
        int score;
        int[] positions;
        @Nullable SearchMatchAlgorithm algo;

        DefaultResult(int start, int end, int score, int[] positions, @Nullable SearchMatchAlgorithm algo) {
            this.start = start;
            this.end = end;
            this.score = score;
            this.positions = positions;
            this.algo = algo;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public int getScore() {
            return this.score;
        }

        @Override
        public int[] getPositions() {
            return this.positions;
        }

        @Override
        public @Nullable SearchMatchAlgorithm getAlgorithm() {
            return this.algo;
        }
    }
}

