/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import org.springframework.shell.jline.tui.table.Aligner;

public enum SimpleHorizontalAligner implements Aligner
{
    left,
    center,
    right;


    @Override
    public String[] align(String[] text, int cellWidth, int cellHeight) {
        String[] result = new String[cellHeight];
        for (int i = 0; i < cellHeight; ++i) {
            int j;
            int padLeft;
            int padRight;
            String line = i < text.length && text[i] != null ? text[i].trim() : "";
            int paddingToDistribute = cellWidth - line.length();
            switch (this) {
                case center: {
                    int carry = paddingToDistribute % 2;
                    padLeft = padRight = (paddingToDistribute -= carry) / 2;
                    padRight += carry;
                    break;
                }
                case right: {
                    padLeft = paddingToDistribute;
                    padRight = 0;
                    break;
                }
                case left: {
                    padLeft = 0;
                    padRight = paddingToDistribute;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            StringBuilder sb = new StringBuilder(cellWidth);
            for (j = 0; j < padLeft; ++j) {
                sb.append(' ');
            }
            sb.append(line);
            for (j = 0; j < padRight; ++j) {
                sb.append(' ');
            }
            result[i] = sb.toString();
        }
        return result;
    }
}

