/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.support.search;

import java.util.ArrayList;
import java.util.List;
import org.springframework.shell.jline.tui.support.search.AbstractSearchMatchAlgorithm;
import org.springframework.shell.jline.tui.support.search.SearchMatchResult;
import org.springframework.util.StringUtils;

class FuzzyMatchV2SearchMatchAlgorithm
extends AbstractSearchMatchAlgorithm {
    FuzzyMatchV2SearchMatchAlgorithm() {
    }

    @Override
    public SearchMatchResult match(boolean caseSensitive, boolean normalize, boolean forward, String text, String pattern) {
        if (!StringUtils.hasText((String)pattern)) {
            return SearchMatchResult.ofZeros();
        }
        int M = pattern.length();
        int N = text.length();
        int idx = FuzzyMatchV2SearchMatchAlgorithm.asciiFuzzyIndex(text, pattern, caseSensitive);
        if (idx < 0) {
            return SearchMatchResult.ofMinus();
        }
        List<Integer> H0 = FuzzyMatchV2SearchMatchAlgorithm.create(N);
        List<Integer> C0 = FuzzyMatchV2SearchMatchAlgorithm.create(N);
        List<Integer> B = FuzzyMatchV2SearchMatchAlgorithm.create(N);
        List<Integer> F = FuzzyMatchV2SearchMatchAlgorithm.create(M);
        Object T = text;
        int maxScore = 0;
        int maxScorePos = 0;
        int pidx = 0;
        int lastIdx = 0;
        char pchar0 = pattern.charAt(0);
        char pchar = pattern.charAt(0);
        int prevH0 = 0;
        AbstractSearchMatchAlgorithm.CharClass prevClass = AbstractSearchMatchAlgorithm.CharClass.WHITE;
        boolean inGap = false;
        int TsubIdxRestore = idx;
        Object Tsub = ((String)T).substring(idx);
        List<Integer> H0sub = FuzzyMatchV2SearchMatchAlgorithm.slicex(H0, idx, ((String)Tsub).length());
        List<Integer> C0sub = FuzzyMatchV2SearchMatchAlgorithm.slicex(C0, idx, ((String)Tsub).length());
        List<Integer> Bsub = FuzzyMatchV2SearchMatchAlgorithm.slicex(B, idx, ((String)Tsub).length());
        for (int off = 0; off < ((String)Tsub).length(); ++off) {
            AbstractSearchMatchAlgorithm.CharClass clazz;
            char c = ((String)Tsub).charAt(off);
            if (c >= ' ' && c < '\u007f') {
                clazz = FuzzyMatchV2SearchMatchAlgorithm.charClassOfAscii(c);
                if (!caseSensitive && clazz == AbstractSearchMatchAlgorithm.CharClass.UPPER) {
                    c = (char)(c + 32);
                }
            } else {
                clazz = FuzzyMatchV2SearchMatchAlgorithm.charClassOfNonAscii(c);
                if (!caseSensitive && clazz == AbstractSearchMatchAlgorithm.CharClass.UPPER) {
                    c = Character.toLowerCase(c);
                }
                if (normalize) {
                    c = FuzzyMatchV2SearchMatchAlgorithm.normalizeRune(c);
                }
            }
            Tsub = ((String)Tsub).substring(0, off) + c + ((String)Tsub).substring(off + 1);
            int bonus = FuzzyMatchV2SearchMatchAlgorithm.bonusFor(prevClass, clazz);
            Bsub.set(off, bonus);
            prevClass = clazz;
            if (c == pchar) {
                if (pidx < M) {
                    F.set(pidx, idx + off);
                    pchar = pattern.charAt(Math.min(++pidx, M - 1));
                }
                lastIdx = idx + off;
            }
            if (c == pchar0) {
                int score = 16 + bonus * 2;
                H0sub.set(off, score);
                C0sub.set(off, 1);
                if (M == 1 && (forward && score > maxScore || !forward && score >= maxScore)) {
                    maxScore = score;
                    maxScorePos = idx + off;
                    if (forward && bonus >= 8) break;
                }
                inGap = false;
            } else {
                if (inGap) {
                    H0sub.set(off, Math.max(prevH0 + -1, 0));
                } else {
                    H0sub.set(off, Math.max(prevH0 + -3, 0));
                }
                C0sub.set(off, 0);
                inGap = true;
            }
            prevH0 = H0sub.get(off);
        }
        T = ((String)T).substring(0, TsubIdxRestore) + (String)Tsub;
        if (pidx != M) {
            return SearchMatchResult.ofMinus();
        }
        if (M == 1) {
            return SearchMatchResult.of(maxScorePos, maxScorePos + 1, maxScore, new int[]{maxScorePos}, this);
        }
        int f0 = F.get(0);
        int width = lastIdx - f0 + 1;
        List<Integer> H = FuzzyMatchV2SearchMatchAlgorithm.create(width * M);
        FuzzyMatchV2SearchMatchAlgorithm.copy(H, H0, f0, lastIdx + 1);
        List<Integer> C = FuzzyMatchV2SearchMatchAlgorithm.create(width * M);
        FuzzyMatchV2SearchMatchAlgorithm.copy(C, C0, f0, lastIdx + 1);
        List<Integer> Fsub = F.subList(1, F.size());
        String Psub = pattern.substring(1);
        Psub = Psub.substring(0, Fsub.size());
        for (int off = 0; off < Fsub.size(); ++off) {
            int f = Fsub.get(off);
            char pchar2 = Psub.charAt(off);
            int pidx2 = off + 1;
            int row = pidx2 * width;
            boolean inGap2 = false;
            String Tsub2 = ((String)T).substring(f, lastIdx + 1);
            List<Integer> Bsub2 = FuzzyMatchV2SearchMatchAlgorithm.slicex(B, f, Tsub2.length());
            List<Integer> Csub2 = FuzzyMatchV2SearchMatchAlgorithm.slicex(C, row + f - f0, Tsub2.length());
            List<Integer> Cdiag = FuzzyMatchV2SearchMatchAlgorithm.slicex(C, row + f - f0 - 1 - width, Tsub2.length());
            List<Integer> Hsub2 = FuzzyMatchV2SearchMatchAlgorithm.slicex(H, row + f - f0, Tsub2.length());
            List<Integer> Hdiag = FuzzyMatchV2SearchMatchAlgorithm.slicex(H, row + f - f0 - 1 - width, Tsub2.length());
            List<Integer> Hleft = FuzzyMatchV2SearchMatchAlgorithm.slicex(H, row + f - f0 - 1, Tsub2.length());
            Hleft.set(0, 0);
            for (int off2 = 0; off2 < Tsub2.length(); ++off2) {
                char c = Tsub2.charAt(off2);
                int col = off2 + f;
                int s1 = 0;
                int s2 = 0;
                int consecutive = 0;
                s2 = inGap2 ? Hleft.get(off2) + -1 : Hleft.get(off2) + -3;
                if (pchar2 == c) {
                    s1 = Hdiag.get(off2) + 16;
                    int b = Bsub2.get(off2);
                    consecutive = Cdiag.get(off2) + 1;
                    if (consecutive > 1) {
                        int fb = B.get(col - consecutive + 1);
                        if (b >= 8 && b > fb) {
                            consecutive = 1;
                        } else {
                            b = Math.max(b, Math.max(4, fb));
                        }
                    }
                    if (s1 + b < s2) {
                        s1 += Bsub2.get(off2).intValue();
                        consecutive = 0;
                    } else {
                        s1 += b;
                    }
                }
                Csub2.set(off2, consecutive);
                inGap2 = s1 < s2;
                int score = Math.max(Math.max(s1, s2), 0);
                if (pidx2 == M - 1 && forward && score > maxScore || !forward && score >= maxScore) {
                    maxScore = score;
                    maxScorePos = col;
                }
                Hsub2.set(off2, score);
            }
        }
        int[] pos = new int[M];
        int j = f0;
        int i = M - 1;
        j = maxScorePos;
        boolean preferMatch = true;
        int posidx = pos.length - 1;
        while (true) {
            int I = i * width;
            int j0 = j - f0;
            int s = H.get(I + j0);
            int s1 = 0;
            int s2 = 0;
            if (i > 0 && j >= F.get(i)) {
                s1 = H.get(I - width + j0 - 1);
            }
            if (j > F.get(i)) {
                s2 = H.get(I + j0 - 1);
            }
            if (s > s1 && (s > s2 || s == s2 && preferMatch)) {
                pos[posidx--] = j;
                if (i == 0) break;
                --i;
            }
            preferMatch = C.get(I + j0) > 1 || I + width + j0 + 1 < C.size() && C.get(I + width + j0 + 1) > 0;
            --j;
        }
        return SearchMatchResult.of(j, maxScorePos + 1, maxScore, pos, this);
    }

    private static List<Integer> slicex(List<Integer> from, int start, int length) {
        return from.subList(start, from.size()).subList(0, length);
    }

    private static void copy(List<Integer> dst, List<Integer> src, int start, int end) {
        int x = 0;
        for (int i = start; i < end; ++i) {
            dst.set(x++, src.get(i));
        }
    }

    private static List<Integer> create(int size) {
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(0);
        }
        return list;
    }
}

