/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.view.control.AbstractView;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.HorizontalAlign;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.shell.jline.tui.geom.VerticalAlign;
import org.springframework.util.StringUtils;

public class BoxView
extends AbstractView {
    private static final Log log = LogFactory.getLog(BoxView.class);
    private @Nullable String title = null;
    private boolean showBorder = false;
    private int innerX = -1;
    private int innerY;
    private int innerWidth;
    private int innerHeight;
    private int paddingTop;
    private int paddingBottom;
    private int paddingLeft;
    private int paddingRight;
    private int backgroundColor = -1;
    private int titleColor = -1;
    private int titleStyle = -1;
    private int focusedTitleColor = -1;
    private int focusedTitleStyle = -1;
    private @Nullable HorizontalAlign titleAlign;

    @Override
    public void setRect(int x, int y, int width, int height) {
        this.innerX = -1;
        super.setRect(x, y, width, height);
    }

    public BoxView setBorderPadding(int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        return this;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    public void setTitleStyle(int titleStyle) {
        this.titleStyle = titleStyle;
    }

    public void setFocusedTitleColor(int focusedTitleColor) {
        this.focusedTitleColor = focusedTitleColor;
    }

    public void setFocusedTitleStyle(int focusedTitleStyle) {
        this.focusedTitleStyle = focusedTitleStyle;
    }

    public void setTitleAlign(HorizontalAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    protected String getBackgroundStyle() {
        return "style-background";
    }

    @Override
    protected void drawBackground(Screen screen) {
        int bgColor = this.resolveThemeBackground(this.getBackgroundStyle(), this.backgroundColor, -1);
        Rectangle rect = this.getRect();
        screen.writerBuilder().layer(this.getLayer()).build().background(rect, bgColor);
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle r;
        log.trace((Object)("drawInternal() " + String.valueOf(this)));
        Rectangle rect = this.getRect();
        if (rect.width() <= 0 || rect.height() <= 0) {
            return;
        }
        if (this.showBorder && rect.width() >= 2 && rect.height() >= 2) {
            screen.writerBuilder().layer(this.getLayer()).build().border(rect.x(), rect.y(), rect.width(), rect.height());
            if (StringUtils.hasText((String)this.title)) {
                r = new Rectangle(rect.x() + 1, rect.y(), rect.width() - 2, 1);
                int color = -1;
                int style = -1;
                if (this.hasFocus()) {
                    color = this.focusedTitleColor;
                    style = this.focusedTitleStyle;
                }
                if (color < 0) {
                    color = this.titleColor;
                }
                if (style < 0) {
                    style = this.titleStyle;
                }
                screen.writerBuilder().layer(this.getLayer()).color(color).style(style).build().text(this.title, r, this.titleAlign, VerticalAlign.TOP);
            }
        }
        if (this.getDrawFunction() != null) {
            r = this.getDrawFunction().apply(screen, rect);
            this.innerX = r.x();
            this.innerY = r.y();
            this.innerWidth = r.width();
            this.innerHeight = r.height();
        } else {
            r = this.getInnerRect();
            this.innerX = r.x();
            this.innerY = r.y();
            this.innerWidth = r.width();
            this.innerHeight = r.height();
        }
    }

    protected Rectangle getInnerRect() {
        if (this.innerX >= 0) {
            return new Rectangle(this.innerX, this.innerY, this.innerWidth, this.innerHeight);
        }
        Rectangle rect = this.getRect();
        int x = rect.x();
        int y = rect.y();
        int width = rect.width();
        int height = rect.height();
        if (this.isShowBorder()) {
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        x += this.paddingLeft;
        y += this.paddingTop;
        width = width - this.paddingLeft - this.paddingRight;
        height = height - this.paddingTop - this.paddingBottom;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Rectangle(x, y, width, height);
    }
}

