/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.shell.jline.tui.component.message.ShellMessageBuilder;
import org.springframework.shell.jline.tui.component.view.control.AbstractControl;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.control.ViewService;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import org.springframework.shell.jline.tui.component.view.event.KeyBindingConsumer;
import org.springframework.shell.jline.tui.component.view.event.KeyBindingConsumerArgs;
import org.springframework.shell.jline.tui.component.view.event.KeyEvent;
import org.springframework.shell.jline.tui.component.view.event.KeyHandler;
import org.springframework.shell.jline.tui.component.view.event.MouseBindingConsumer;
import org.springframework.shell.jline.tui.component.view.event.MouseBindingConsumerArgs;
import org.springframework.shell.jline.tui.component.view.event.MouseEvent;
import org.springframework.shell.jline.tui.component.view.event.MouseHandler;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.Rectangle;
import reactor.core.Disposable;
import reactor.core.Disposables;

public abstract class AbstractView
extends AbstractControl
implements View {
    private static final Log log = LogFactory.getLog(AbstractView.class);
    private final Disposable.Composite disposables = Disposables.composite();
    private @Nullable BiFunction<Screen, Rectangle, Rectangle> drawFunction;
    private boolean hasFocus;
    private int layer;
    private @Nullable EventLoop eventLoop;
    private @Nullable ViewService viewService;
    private final Map<String, Runnable> commands = new HashMap<String, Runnable>();
    private Map<Integer, KeyBindingValue> keyBindings = new HashMap<Integer, KeyBindingValue>();
    private Map<Integer, KeyBindingValue> hotKeyBindings = new HashMap<Integer, KeyBindingValue>();
    private Map<Integer, MouseBindingValue> mouseBindings = new HashMap<Integer, MouseBindingValue>();
    private boolean init = false;
    private @Nullable Integer shortcutKey;
    private @Nullable Runnable shortcutAction;

    protected void onDestroy(Disposable disposable) {
        this.disposables.add(disposable);
    }

    public void destroy() {
        this.disposables.dispose();
    }

    @Override
    public final void init() {
        if (this.init) {
            return;
        }
        this.initInternal();
        this.init = true;
    }

    public void shortcut(Integer key, Runnable runnable) {
        this.shortcutKey = key;
        this.shortcutAction = runnable;
    }

    protected void initInternal() {
        if (this.shortcutKey != null && this.shortcutAction != null) {
            this.registerHotKeyBinding(this.shortcutKey, this.shortcutAction);
        }
    }

    @Override
    public void setLayer(int index) {
        this.layer = index;
    }

    protected int getLayer() {
        return this.layer;
    }

    @Override
    public final void draw(Screen screen) {
        this.drawBackground(screen);
        this.drawInternal(screen);
    }

    protected abstract void drawInternal(Screen var1);

    protected void drawBackground(Screen screen) {
    }

    @Override
    public void focus(View view, boolean focus) {
        log.debug((Object)("Focus view=" + String.valueOf(view) + " focus=" + focus));
        if (view == this && focus) {
            this.hasFocus = true;
        }
        if (!focus) {
            this.hasFocus = false;
        }
    }

    @Override
    public boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public MouseHandler getMouseHandler() {
        log.trace((Object)("getMouseHandler() " + String.valueOf(this)));
        return args -> {
            Predicate<MouseEvent> mouseEventPredicate;
            MouseEvent event = args.event();
            int mouse = event.mouse();
            AbstractView view = null;
            boolean consumed = false;
            MouseBindingValue mouseBindingValue = this.getMouseBindings().get(mouse);
            if (mouseBindingValue != null && (mouseEventPredicate = mouseBindingValue.mousePredicate()) != null && mouseEventPredicate.test(event)) {
                view = this;
                consumed = this.dispatchMouseRunCommand(event, mouseBindingValue);
            }
            if (view == null && this.getRect().contains(event.x(), event.y())) {
                view = this;
            }
            return MouseHandler.resultOf(args.event(), consumed, view, this);
        };
    }

    @Override
    public KeyHandler getKeyHandler() {
        log.trace((Object)("getKeyHandler() " + String.valueOf(this)));
        KeyHandler handler = args -> {
            KeyBindingValue keyBindingValue;
            KeyEvent event = args.event();
            boolean consumed = false;
            Integer key = event.key();
            if (key != null && (keyBindingValue = this.getKeyBindings().get(key)) != null) {
                consumed = this.dispatchKeyRunCommand(event, keyBindingValue);
            }
            return KeyHandler.resultOf(event, consumed, null);
        };
        return handler;
    }

    @Override
    public KeyHandler getHotKeyHandler() {
        log.trace((Object)("getHotKeyHandler() " + String.valueOf(this)));
        return args -> {
            KeyBindingValue keyBindingValue;
            KeyEvent event = args.event();
            AbstractView view = null;
            boolean consumed = false;
            Integer key = event.key();
            if (key != null && (keyBindingValue = this.getHotKeyBindings().get(key)) != null) {
                view = this;
                consumed = this.dispatchKeyRunCommand(event, keyBindingValue);
            }
            return KeyHandler.resultOf(event, consumed, view);
        };
    }

    public void setDrawFunction(BiFunction<Screen, Rectangle, Rectangle> drawFunction) {
        this.drawFunction = drawFunction;
    }

    public @Nullable BiFunction<Screen, Rectangle, Rectangle> getDrawFunction() {
        return this.drawFunction;
    }

    @Override
    public void setEventLoop(@Nullable EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    protected @Nullable EventLoop getEventLoop() {
        return this.eventLoop;
    }

    @Override
    public void setViewService(@Nullable ViewService viewService) {
        this.viewService = viewService;
    }

    protected @Nullable ViewService getViewService() {
        return this.viewService;
    }

    protected void registerViewCommand(String command, Runnable runnable) {
        this.commands.put(command, runnable);
    }

    @Override
    public Set<String> getViewCommands() {
        return this.commands.keySet();
    }

    protected void registerKeyBinding(Integer keyType, String keyCommand) {
        this.registerKeyBinding(keyType, keyCommand, null, null);
    }

    protected void registerKeyBinding(Integer keyType, KeyBindingConsumer keyConsumer) {
        this.registerKeyBinding(keyType, null, keyConsumer, null);
    }

    protected void registerKeyBinding(Integer keyType, Runnable keyRunnable) {
        this.registerKeyBinding(keyType, null, null, keyRunnable);
    }

    private void registerKeyBinding(Integer keyType, @Nullable String keyCommand, @Nullable KeyBindingConsumer keyConsumer, @Nullable Runnable keyRunnable) {
        this.keyBindings.compute(keyType, (key, old) -> KeyBindingValue.of(old, keyCommand, keyConsumer, keyRunnable));
    }

    protected void registerHotKeyBinding(Integer keyType, String keyCommand) {
        this.registerHotKeyBinding(keyType, keyCommand, null, null);
    }

    protected void registerHotKeyBinding(Integer keyType, KeyBindingConsumer keyConsumer) {
        this.registerHotKeyBinding(keyType, null, keyConsumer, null);
    }

    protected void registerHotKeyBinding(Integer keyType, Runnable keyRunnable) {
        this.registerHotKeyBinding(keyType, null, null, keyRunnable);
    }

    private void registerHotKeyBinding(Integer keyType, @Nullable String keyCommand, @Nullable KeyBindingConsumer keyConsumer, @Nullable Runnable keyRunnable) {
        this.hotKeyBindings.compute(keyType, (key, old) -> KeyBindingValue.of(old, keyCommand, keyConsumer, keyRunnable));
    }

    protected Map<Integer, KeyBindingValue> getKeyBindings() {
        return this.keyBindings;
    }

    protected Map<Integer, KeyBindingValue> getHotKeyBindings() {
        return this.hotKeyBindings;
    }

    protected Map<Integer, MouseBindingValue> getMouseBindings() {
        return this.mouseBindings;
    }

    protected void registerMouseBinding(Integer keyType, String mouseCommand) {
        this.registerMouseBinding(keyType, mouseCommand, null, null);
    }

    protected void registerMouseBinding(Integer keyType, MouseBindingConsumer mouseConsumer) {
        this.registerMouseBinding(keyType, null, mouseConsumer, null);
    }

    protected void registerMouseBinding(Integer keyType, Runnable mouseRunnable) {
        this.registerMouseBinding(keyType, null, null, mouseRunnable);
    }

    private void registerMouseBinding(Integer mouseType, @Nullable String mouseCommand, @Nullable MouseBindingConsumer mouseConsumer, @Nullable Runnable mouseRunnable) {
        Predicate<MouseEvent> mousePredicate = event -> {
            int x = event.x();
            int y = event.y();
            return this.getRect().contains(x, y);
        };
        this.mouseBindings.compute(mouseType, (key, old) -> MouseBindingValue.of(old, mouseCommand, mouseConsumer, mouseRunnable, mousePredicate));
    }

    protected void dispatch(Message<?> message) {
        if (this.eventLoop != null) {
            this.eventLoop.dispatch(message);
        } else {
            log.warn((Object)("Can't dispatch message " + String.valueOf(message) + " as eventloop is not set"));
        }
    }

    protected boolean dispatchRunnable(Runnable runnable) {
        if (this.eventLoop == null) {
            return false;
        }
        Message<Runnable> message = ShellMessageBuilder.withPayload(runnable).setEventType(EventLoop.Type.TASK).build();
        this.dispatch(message);
        return true;
    }

    @Override
    public boolean runViewCommand(@Nullable String command) {
        Runnable runnable;
        if (this.eventLoop == null) {
            return false;
        }
        if (command != null && (runnable = this.commands.get(command)) != null) {
            Message<Runnable> message = ShellMessageBuilder.withPayload(runnable).setEventType(EventLoop.Type.TASK).build();
            this.dispatch(message);
            return true;
        }
        return false;
    }

    protected boolean dispatchKeyRunCommand(KeyEvent event, KeyBindingValue keyBindingValue) {
        if (this.eventLoop == null) {
            return false;
        }
        String keyCommand = keyBindingValue.keyCommand();
        if (this.runViewCommand(keyCommand)) {
            return true;
        }
        Runnable keyRunnable = keyBindingValue.keyRunnable();
        if (keyRunnable != null) {
            Message<Runnable> message = ShellMessageBuilder.withPayload(keyRunnable).setEventType(EventLoop.Type.TASK).build();
            this.dispatch(message);
            return true;
        }
        KeyBindingConsumer keyConsumer = keyBindingValue.keyConsumer();
        if (keyConsumer != null) {
            Message<KeyBindingConsumerArgs> message = ShellMessageBuilder.withPayload(new KeyBindingConsumerArgs(keyConsumer, event)).setEventType(EventLoop.Type.TASK).build();
            this.dispatch(message);
            return true;
        }
        return false;
    }

    protected boolean dispatchMouseRunCommand(MouseEvent event, MouseBindingValue mouseBindingValue) {
        if (this.eventLoop == null) {
            return false;
        }
        String mouseCommand = mouseBindingValue.mouseCommand();
        if (this.runViewCommand(mouseCommand)) {
            return true;
        }
        Runnable mouseRunnable = mouseBindingValue.mouseRunnable();
        if (mouseRunnable != null) {
            Message<Runnable> message = ShellMessageBuilder.withPayload(mouseRunnable).setEventType(EventLoop.Type.TASK).build();
            this.dispatch(message);
            return true;
        }
        MouseBindingConsumer mouseConsumer = mouseBindingValue.mouseConsumer();
        if (mouseConsumer != null) {
            Message<MouseBindingConsumerArgs> message = ShellMessageBuilder.withPayload(new MouseBindingConsumerArgs(mouseConsumer, event)).setEventType(EventLoop.Type.TASK).build();
            this.dispatch(message);
            return true;
        }
        return false;
    }

    record KeyBindingValue(@Nullable String keyCommand, @Nullable KeyBindingConsumer keyConsumer, @Nullable Runnable keyRunnable) {
        static KeyBindingValue of(@Nullable KeyBindingValue old, @Nullable String keyCommand, @Nullable KeyBindingConsumer keyConsumer, @Nullable Runnable keyRunnable) {
            if (old == null) {
                return new KeyBindingValue(keyCommand, keyConsumer, keyRunnable);
            }
            return new KeyBindingValue(keyCommand != null ? keyCommand : old.keyCommand(), keyConsumer != null ? keyConsumer : old.keyConsumer(), keyRunnable != null ? keyRunnable : old.keyRunnable());
        }
    }

    record MouseBindingValue(@Nullable String mouseCommand, @Nullable MouseBindingConsumer mouseConsumer, @Nullable Runnable mouseRunnable, @Nullable Predicate<MouseEvent> mousePredicate) {
        static MouseBindingValue of(@Nullable MouseBindingValue old, @Nullable String mouseCommand, @Nullable MouseBindingConsumer mouseConsumer, @Nullable Runnable mouseRunnable, @Nullable Predicate<MouseEvent> mousePredicate) {
            if (old == null) {
                return new MouseBindingValue(mouseCommand, mouseConsumer, mouseRunnable, mousePredicate);
            }
            return new MouseBindingValue(mouseCommand != null ? mouseCommand : old.mouseCommand(), mouseConsumer != null ? mouseConsumer : old.mouseConsumer(), mouseRunnable != null ? mouseRunnable : old.mouseRunnable(), mousePredicate != null ? mousePredicate : old.mousePredicate());
        }
    }
}

