/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.PathInput;
import org.springframework.shell.jline.tui.component.flow.BaseInput;
import org.springframework.shell.jline.tui.component.flow.ComponentFlow;
import org.springframework.shell.jline.tui.component.flow.PathInputSpec;
import org.springframework.shell.jline.tui.component.flow.ResultMode;

public abstract class BasePathInput
extends BaseInput<PathInputSpec>
implements PathInputSpec {
    private @Nullable String name;
    private @Nullable String resultValue;
    private @Nullable ResultMode resultMode;
    private @Nullable String defaultValue;
    private @Nullable Function<PathInput.PathInputContext, List<AttributedString>> renderer;
    private List<Consumer<PathInput.PathInputContext>> preHandlers = new ArrayList<Consumer<PathInput.PathInputContext>>();
    private List<Consumer<PathInput.PathInputContext>> postHandlers = new ArrayList<Consumer<PathInput.PathInputContext>>();
    private boolean storeResult = true;
    private @Nullable String templateLocation;
    private @Nullable Function<PathInput.PathInputContext, String> next;

    public BasePathInput(ComponentFlow.BaseBuilder builder, String id) {
        super(builder, id);
    }

    @Override
    public PathInputSpec name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public PathInputSpec resultValue(String resultValue) {
        this.resultValue = resultValue;
        return this;
    }

    @Override
    public PathInputSpec resultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
        return this;
    }

    @Override
    public PathInputSpec defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public PathInputSpec renderer(Function<PathInput.PathInputContext, List<AttributedString>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public PathInputSpec template(String location) {
        this.templateLocation = location;
        return this;
    }

    @Override
    public PathInputSpec preHandler(Consumer<PathInput.PathInputContext> handler) {
        this.preHandlers.add(handler);
        return this;
    }

    @Override
    public PathInputSpec postHandler(Consumer<PathInput.PathInputContext> handler) {
        this.postHandlers.add(handler);
        return this;
    }

    @Override
    public PathInputSpec storeResult(boolean store) {
        this.storeResult = store;
        return this;
    }

    @Override
    public PathInputSpec next(Function<PathInput.PathInputContext, String> next) {
        this.next = next;
        return this;
    }

    @Override
    public ComponentFlow.Builder and() {
        this.getBuilder().addPathInput(this);
        return this.getBuilder();
    }

    @Override
    public PathInputSpec getThis() {
        return this;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getResultValue() {
        return this.resultValue;
    }

    public @Nullable ResultMode getResultMode() {
        return this.resultMode;
    }

    public @Nullable String getDefaultValue() {
        return this.defaultValue;
    }

    public @Nullable Function<PathInput.PathInputContext, List<AttributedString>> getRenderer() {
        return this.renderer;
    }

    public @Nullable String getTemplateLocation() {
        return this.templateLocation;
    }

    public List<Consumer<PathInput.PathInputContext>> getPreHandlers() {
        return this.preHandlers;
    }

    public List<Consumer<PathInput.PathInputContext>> getPostHandlers() {
        return this.postHandlers;
    }

    public boolean isStoreResult() {
        return this.storeResult;
    }

    public @Nullable Function<PathInput.PathInputContext, String> getNext() {
        return this.next;
    }
}

