/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.shell.jline.tui.table.TableModel;
import org.springframework.util.Assert;

public class BeanListTableModel<T>
extends TableModel {
    private final List<BeanWrapper> data = new ArrayList<BeanWrapper>();
    private final List<String> propertyNames;
    private final @Nullable List<Object> headerRow;

    public BeanListTableModel(Class<T> clazz, Iterable<T> list) {
        for (T bean : list) {
            this.data.add((BeanWrapper)new BeanWrapperImpl(bean));
        }
        this.headerRow = null;
        this.propertyNames = new ArrayList<String>();
        for (PropertyDescriptor propertyName : BeanUtils.getPropertyDescriptors(clazz)) {
            if ("class".equals(propertyName.getName())) continue;
            this.propertyNames.add(propertyName.getName());
        }
    }

    public BeanListTableModel(Iterable<T> list, String ... propertyNames) {
        for (T bean : list) {
            this.data.add((BeanWrapper)new BeanWrapperImpl(bean));
        }
        this.headerRow = null;
        this.propertyNames = Arrays.asList(propertyNames);
    }

    public BeanListTableModel(Iterable<T> list, LinkedHashMap<String, Object> header) {
        for (T bean : list) {
            this.data.add((BeanWrapper)new BeanWrapperImpl(bean));
        }
        this.headerRow = new ArrayList<Object>(header.values());
        this.propertyNames = new ArrayList<String>(header.keySet());
    }

    @Override
    public int getRowCount() {
        return this.headerRow == null ? this.data.size() : 1 + this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.propertyNames.size();
    }

    @Override
    public @Nullable Object getValue(int row, int column) {
        if (this.headerRow != null && row == 0) {
            return this.headerRow.get(column);
        }
        int rowToUse = this.headerRow == null ? row : row - 1;
        String propertyName = this.propertyNames.get(column);
        BeanWrapper beanWrapper = this.data.get(rowToUse);
        Assert.notNull((Object)beanWrapper, (String)"'beanWrapper' must not be null");
        return beanWrapper.getPropertyValue(propertyName);
    }
}

