/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.support.search;

import org.springframework.shell.jline.tui.support.search.AbstractSearchMatchAlgorithm;
import org.springframework.shell.jline.tui.support.search.SearchMatchResult;

class FuzzyMatchV1SearchMatchAlgorithm
extends AbstractSearchMatchAlgorithm {
    FuzzyMatchV1SearchMatchAlgorithm() {
    }

    @Override
    public SearchMatchResult match(boolean caseSensitive, boolean normalize, boolean forward, String text, String pattern) {
        int pidx = 0;
        int sidx = -1;
        int eidx = -1;
        int lenRunes = text.length();
        int lenPattern = pattern.length();
        for (int index = 0; index < lenRunes; ++index) {
            char pchar;
            char c = text.charAt(FuzzyMatchV1SearchMatchAlgorithm.indexAt(index, lenRunes, forward));
            if (!caseSensitive && c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (normalize) {
                c = FuzzyMatchV1SearchMatchAlgorithm.normalizeRune(c);
            }
            if (c != (pchar = pattern.charAt(FuzzyMatchV1SearchMatchAlgorithm.indexAt(pidx, lenPattern, forward)))) continue;
            if (sidx < 0) {
                sidx = index;
            }
            if (++pidx != lenPattern) continue;
            eidx = index + 1;
            break;
        }
        if (sidx >= 0 && eidx >= 0) {
            --pidx;
            for (int i = eidx - 1; i >= sidx; --i) {
                int pidx_;
                char pchar;
                int tidx = FuzzyMatchV1SearchMatchAlgorithm.indexAt(i, lenRunes, forward);
                char c = text.charAt(tidx);
                if (!caseSensitive && c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if (c != (pchar = pattern.charAt(pidx_ = FuzzyMatchV1SearchMatchAlgorithm.indexAt(pidx, lenPattern, forward))) || --pidx >= 0) continue;
                sidx = i;
                break;
            }
            if (!forward) {
                int sidxOrig = sidx;
                sidx = lenRunes - eidx;
                eidx = lenRunes - sidxOrig;
            }
            AbstractSearchMatchAlgorithm.CalculateScore calculateScore = FuzzyMatchV1SearchMatchAlgorithm.calculateScore(caseSensitive, normalize, text, pattern, sidx, eidx);
            return SearchMatchResult.of(sidx, eidx, calculateScore.score, calculateScore.pos, this);
        }
        return SearchMatchResult.of(-1, -1, 0, new int[0], this);
    }
}

