/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.event.processor;

import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.shell.jline.tui.component.message.StaticShellMessageHeaderAccessor;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import org.springframework.shell.jline.tui.component.view.event.KeyBindingConsumerArgs;
import org.springframework.shell.jline.tui.component.view.event.MouseBindingConsumerArgs;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TaskEventLoopProcessor
implements EventLoop.EventLoopProcessor {
    @Override
    public boolean canProcess(Message<?> message) {
        if (EventLoop.Type.TASK.equals((Object)StaticShellMessageHeaderAccessor.getEventType(message))) {
            Object payload = message.getPayload();
            if (payload instanceof Runnable) {
                return true;
            }
            if (payload instanceof KeyBindingConsumerArgs) {
                return true;
            }
            if (payload instanceof MouseBindingConsumerArgs) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Flux<? extends Message<?>> process(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof Runnable) {
            return this.processRunnable(message);
        }
        if (payload instanceof KeyBindingConsumerArgs) {
            return this.processKeyConsumer(message);
        }
        if (payload instanceof MouseBindingConsumerArgs) {
            return this.processMouseConsumer(message);
        }
        throw new IllegalArgumentException();
    }

    private Flux<? extends Message<?>> processRunnable(Message<?> message) {
        return Mono.just((Object)message.getPayload()).ofType(Runnable.class).flatMap(Mono::fromRunnable).then(Mono.just((Object)MessageBuilder.withPayload((Object)new Object()).build())).flux();
    }

    private Flux<? extends Message<?>> processMouseConsumer(Message<?> message) {
        return Mono.just((Object)message.getPayload()).ofType(MouseBindingConsumerArgs.class).flatMap(args -> Mono.fromRunnable(() -> args.consumer().accept(args.event()))).then(Mono.just((Object)MessageBuilder.withPayload((Object)new Object()).build())).flux();
    }

    private Flux<? extends Message<?>> processKeyConsumer(Message<?> message) {
        return Mono.just((Object)message.getPayload()).ofType(KeyBindingConsumerArgs.class).flatMap(args -> Mono.fromRunnable(() -> args.consumer().accept(args.event()))).then(Mono.just((Object)MessageBuilder.withPayload((Object)new Object()).build())).flux();
    }
}

