/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.event;

import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.event.KeyEvent;

@FunctionalInterface
public interface KeyHandler {
    public KeyHandlerResult handle(KeyHandlerArgs var1);

    default public KeyHandler thenConditionally(KeyHandler other, Predicate<KeyHandlerResult> predicate) {
        return args -> {
            KeyHandlerResult result = this.handle(args);
            if (predicate.test(result)) {
                return other.handle(args);
            }
            return result;
        };
    }

    default public KeyHandler thenIfConsumed(KeyHandler other) {
        return this.thenConditionally(other, result -> result.consumed());
    }

    default public KeyHandler thenIfNotConsumed(KeyHandler other) {
        return this.thenConditionally(other, result -> !result.consumed());
    }

    public static KeyHandler neverConsume() {
        return args -> KeyHandler.resultOf(args.event(), false, null);
    }

    public static KeyHandlerArgs argsOf(KeyEvent event) {
        return new KeyHandlerArgs(event);
    }

    public static KeyHandlerResult resultOf(KeyEvent event, boolean consumed, @Nullable View focus) {
        return new KeyHandlerResult(event, consumed, focus, null);
    }

    public record KeyHandlerArgs(KeyEvent event) {
    }

    public record KeyHandlerResult(@Nullable KeyEvent event, boolean consumed, @Nullable View focus, @Nullable View capture) {
    }
}

