/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control.cell;

import java.util.function.Function;
import org.springframework.shell.jline.tui.component.view.control.cell.AbstractCell;
import org.springframework.shell.jline.tui.component.view.control.cell.TextCell;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.HorizontalAlign;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.shell.jline.tui.geom.VerticalAlign;

public abstract class AbstractTextCell<T>
extends AbstractCell<T>
implements TextCell<T> {
    private Function<T, String> itemFunction;
    private HorizontalAlign hAlign = HorizontalAlign.CENTER;
    private VerticalAlign vAlign = VerticalAlign.CENTER;

    public AbstractTextCell(T item, Function<T, String> itemFunction) {
        this(item, itemFunction, HorizontalAlign.CENTER, VerticalAlign.CENTER);
    }

    public AbstractTextCell(T item, Function<T, String> itemFunction, HorizontalAlign hAlign, VerticalAlign vAlign) {
        super(item);
        this.itemFunction = itemFunction;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    @Override
    public void setHorizontalAlign(HorizontalAlign hAlign) {
        this.hAlign = hAlign;
    }

    @Override
    public void setVerticalAlign(VerticalAlign vAlign) {
        this.vAlign = vAlign;
    }

    protected String getBackgroundStyle() {
        return "style-background";
    }

    @Override
    protected void drawBackground(Screen screen) {
        Rectangle rect = this.getRect();
        int bgColor = this.resolveThemeBackground(this.getBackgroundStyle(), this.getBackgroundColor(), -1);
        if (bgColor > -1) {
            screen.writerBuilder().build().background(rect, bgColor);
        }
    }

    @Override
    protected void drawContent(Screen screen) {
        String text = this.itemFunction.apply(this.getItem());
        if (text != null) {
            Rectangle rect = this.getRect();
            Screen.Writer writer = screen.writerBuilder().style(this.getStyle()).color(this.getForegroundColor()).build();
            writer.text(text, rect, this.hAlign, this.vAlign);
        }
    }
}

