/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.message.ShellMessageBuilder;
import org.springframework.shell.jline.tui.component.view.control.BoxView;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.control.ViewEvent;
import org.springframework.shell.jline.tui.component.view.control.ViewEventArgs;
import org.springframework.shell.jline.tui.component.view.event.MouseEvent;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.Dimension;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MenuView
extends BoxView {
    private final Log log = LogFactory.getLog(MenuView.class);
    private final List<MenuItem> items = new ArrayList<MenuItem>();
    private int activeItemIndex = -1;
    private @Nullable MenuItem radioActive;
    private Set<MenuItem> checkedActive = new HashSet<MenuItem>();

    public MenuView() {
        this(new MenuItem[0]);
    }

    public MenuView(MenuItem[] items) {
        this(items != null ? Arrays.asList(items) : Collections.emptyList());
    }

    public MenuView(@Nullable List<MenuItem> items) {
        this.setItems(items);
    }

    public void setItems(@Nullable List<MenuItem> items) {
        this.items.clear();
        this.activeItemIndex = -1;
        if (items != null) {
            this.items.addAll(items);
            if (!items.isEmpty()) {
                this.activeItemIndex = 0;
            }
            items.forEach(i -> {
                if (i.initialCheckState && i.getCheckStyle() == MenuItemCheckStyle.CHECKED) {
                    this.checkedActive.add((MenuItem)i);
                } else if (i.initialCheckState && i.getCheckStyle() == MenuItemCheckStyle.RADIO) {
                    this.radioActive = i;
                }
            });
        }
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public Dimension getPreferredDimension() {
        int width = 0;
        int height = this.items.size();
        if (this.isShowBorder()) {
            height += 2;
        }
        for (MenuItem item : this.items) {
            int l = item.getTitle().length();
            if (item.getCheckStyle() != MenuItemCheckStyle.CHECKED) {
                l += 4;
                if (this.isShowBorder()) {
                    l += 2;
                }
            }
            width = Math.max(width, l);
        }
        return new Dimension(width, height);
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        int y = rect.y();
        int selectedStyle = this.resolveThemeStyle("style-highlight", 1);
        int selectedForegroundColor = this.resolveThemeForeground("style-highlight", -1, -1);
        int selectedBackgroundColor = this.resolveThemeBackground("style-highlight", -1, -1);
        Screen.Writer writer = screen.writerBuilder().layer(this.getLayer()).build();
        Screen.Writer selectedWriter = screen.writerBuilder().layer(this.getLayer()).color(selectedForegroundColor).style(selectedStyle).build();
        int i = 0;
        boolean hasCheck = false;
        for (MenuItem item : this.items) {
            if (item.getCheckStyle() == MenuItemCheckStyle.NOCHECK) continue;
            hasCheck = true;
            break;
        }
        for (MenuItem item : this.items) {
            String prefix;
            String string = prefix = hasCheck ? "    " : "";
            if (item.checkStyle == MenuItemCheckStyle.RADIO) {
                prefix = this.radioActive == item ? "[x] " : "[ ] ";
            } else if (item.checkStyle == MenuItemCheckStyle.CHECKED) {
                prefix = this.checkedActive.contains(item) ? "[x] " : "[ ] ";
            }
            String text = prefix + item.getTitle();
            if (this.activeItemIndex == i) {
                selectedWriter.text(text, rect.x(), y);
                if (selectedBackgroundColor > -1) {
                    Rectangle itemRect = new Rectangle(rect.x(), y, rect.width(), 1);
                    selectedWriter.background(itemRect, selectedBackgroundColor);
                }
            } else {
                writer.text(text, rect.x(), y);
            }
            ++i;
            ++y;
        }
        super.drawInternal(screen);
    }

    @Override
    protected void initInternal() {
        this.registerKeyBinding((Integer)0x100000, () -> this.move(-1));
        this.registerKeyBinding((Integer)0x100001, () -> this.move(1));
        this.registerKeyBinding((Integer)0x100004, () -> this.keySelect());
        this.registerMouseBinding((Integer)65, event -> this.mouseSelect((MouseEvent)event));
        this.registerMouseBinding((Integer)1028, () -> this.move(1));
        this.registerMouseBinding((Integer)516, () -> this.move(-1));
    }

    private void keySelect() {
        this.select();
    }

    private void mouseSelect(MouseEvent event) {
        this.log.trace((Object)("select(" + String.valueOf(event) + ")"));
        this.setSelected(this.indexAtPosition(event.x(), event.y()));
        this.select();
    }

    public void toggle(MenuItem item) {
        if (item.checkStyle == MenuItemCheckStyle.RADIO) {
            this.radioActive = item;
        } else if (item.checkStyle == MenuItemCheckStyle.CHECKED) {
            if (this.checkedActive.contains(item)) {
                this.checkedActive.remove(item);
            } else {
                this.checkedActive.add(item);
            }
        }
    }

    private void select() {
        if (this.activeItemIndex > -1 && this.activeItemIndex < this.items.size()) {
            MenuItem item = this.items.get(this.activeItemIndex);
            if (item == null) {
                return;
            }
            this.toggle(item);
            this.dispatch(ShellMessageBuilder.ofView(this, MenuViewOpenSelectedItemEvent.of(this, item)));
            if (item.getAction() != null) {
                this.dispatchRunnable(item.getAction());
            }
        }
    }

    private void move(int count) {
        this.log.trace((Object)("move(" + count + ")"));
        this.setSelected(this.activeItemIndex + count);
    }

    private void setSelected(int index) {
        if (index >= this.items.size()) {
            this.activeItemIndex = 0;
        } else if (index < 0) {
            this.activeItemIndex = this.items.size() - 1;
        } else if (this.activeItemIndex != index) {
            this.activeItemIndex = index;
            MenuItem item = this.items.get(index);
            this.dispatch(ShellMessageBuilder.ofView(this, MenuViewSelectedItemChangedEvent.of(this, item)));
        }
    }

    private int indexAtPosition(int x, int y) {
        MenuItem i;
        Rectangle rect = this.getRect();
        if (!rect.contains(x, y)) {
            return -1;
        }
        int pos = y - rect.y() - 1;
        if (pos > -1 && pos < this.items.size() && (i = this.items.get(pos)) != null) {
            return pos;
        }
        return -1;
    }

    public static class MenuItem {
        private final String title;
        private final @Nullable MenuItemCheckStyle checkStyle;
        private final @Nullable List<MenuItem> items;
        private @Nullable Runnable action;
        private boolean initialCheckState = false;

        public MenuItem(String title) {
            this(title, MenuItemCheckStyle.NOCHECK);
        }

        public MenuItem(String title, MenuItemCheckStyle checkStyle) {
            this(title, checkStyle, null);
        }

        public MenuItem(String title, MenuItemCheckStyle checkStyle, @Nullable Runnable action) {
            this(title, checkStyle, action, false);
        }

        public MenuItem(String title, MenuItemCheckStyle checkStyle, @Nullable Runnable action, boolean initialCheckState) {
            Assert.state((boolean)StringUtils.hasText((String)title), (String)"title must have text");
            Assert.notNull((Object)((Object)checkStyle), (String)"check style cannot be null");
            this.title = title;
            this.checkStyle = checkStyle;
            this.action = action;
            this.items = null;
            this.initialCheckState = initialCheckState;
        }

        protected MenuItem(String title, MenuItem[] items) {
            this(title, Arrays.asList(items));
        }

        protected MenuItem(String title, List<MenuItem> items) {
            Assert.state((boolean)StringUtils.hasText((String)title), (String)"title must have text");
            Assert.notNull(items, (String)"Sub items cannot be null");
            this.title = title;
            this.items = items;
            this.checkStyle = null;
        }

        public static MenuItem of(String title) {
            return new MenuItem(title);
        }

        public static MenuItem of(String title, MenuItemCheckStyle checkStyle) {
            return new MenuItem(title, checkStyle);
        }

        public static MenuItem of(String title, MenuItemCheckStyle checkStyle, Runnable action) {
            return new MenuItem(title, checkStyle, action);
        }

        public static MenuItem of(String title, MenuItemCheckStyle checkStyle, Runnable action, boolean initialCheckState) {
            return new MenuItem(title, checkStyle, action, initialCheckState);
        }

        public @Nullable Runnable getAction() {
            return this.action;
        }

        public void setAction(Runnable action) {
            this.action = action;
        }

        public boolean isInitialCheckState() {
            return this.initialCheckState;
        }

        public String getTitle() {
            return this.title;
        }

        public @Nullable MenuItemCheckStyle getCheckStyle() {
            return this.checkStyle;
        }

        public @Nullable List<MenuItem> getItems() {
            return this.items;
        }
    }

    public static enum MenuItemCheckStyle {
        NOCHECK,
        CHECKED,
        RADIO;

    }

    public static final class MenuViewOpenSelectedItemEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final MenuViewItemEventArgs args;

        public MenuViewOpenSelectedItemEvent(View view, MenuViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static MenuViewOpenSelectedItemEvent of(View view, MenuItem item) {
            return new MenuViewOpenSelectedItemEvent(view, MenuViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MenuViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MenuViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MenuViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public MenuViewItemEventArgs args() {
            return this.args;
        }
    }

    public static final class MenuViewSelectedItemChangedEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final MenuViewItemEventArgs args;

        public MenuViewSelectedItemChangedEvent(View view, MenuViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static MenuViewSelectedItemChangedEvent of(View view, MenuItem item) {
            return new MenuViewSelectedItemChangedEvent(view, MenuViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MenuViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MenuViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MenuViewSelectedItemChangedEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public MenuViewItemEventArgs args() {
            return this.args;
        }
    }

    public record MenuViewItemEventArgs(MenuItem item) implements ViewEventArgs
    {
        public static MenuViewItemEventArgs of(MenuItem item) {
            return new MenuViewItemEventArgs(item);
        }
    }

    public static class Menu
    extends MenuItem {
        public Menu(String title) {
            super(title);
        }

        public Menu(String title, MenuItem[] items) {
            super(title, items);
        }

        public Menu(String title, List<MenuItem> items) {
            super(title, items);
        }

        public static Menu of(String title, MenuItem ... items) {
            return new Menu(title, items);
        }
    }
}

