/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.view.control.BoxView;
import org.springframework.shell.jline.tui.component.view.control.MenuView;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import org.springframework.shell.jline.tui.component.view.event.KeyHandler;
import org.springframework.shell.jline.tui.component.view.event.MouseEvent;
import org.springframework.shell.jline.tui.component.view.event.MouseHandler;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.Dimension;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.shell.jline.tui.style.ThemeResolver;

public class MenuBarView
extends BoxView {
    private final Log log = LogFactory.getLog(MenuBarView.class);
    private final List<MenuBarItem> items = new ArrayList<MenuBarItem>();
    private @Nullable MenuView currentMenuView;
    private int activeItemIndex = -1;
    private final Map<MenuBarItem, MenuView> menuViews = new HashMap<MenuBarItem, MenuView>();

    public MenuBarView(MenuBarItem[] items) {
        this.setItems(Arrays.asList(items));
    }

    public static MenuBarView of(MenuBarItem ... items) {
        return new MenuBarView(items);
    }

    @Override
    protected String getBackgroundStyle() {
        return "style-menubar-background";
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        this.log.debug((Object)("Drawing menu bar to " + String.valueOf(rect)));
        Screen.Writer writer1 = screen.writerBuilder().build();
        Screen.Writer writer2 = screen.writerBuilder().style(1).build();
        int x = rect.x();
        ListIterator<MenuBarItem> iter = this.items.listIterator();
        while (iter.hasNext()) {
            MenuBarItem item = iter.next();
            int index = iter.previousIndex();
            Screen.Writer writer = this.activeItemIndex == index ? writer2 : writer1;
            String text = String.format(" %s%s", item.getTitle(), iter.hasNext() ? " " : "");
            writer.text(text, x, rect.y());
            x += text.length();
        }
        if (this.currentMenuView != null) {
            this.currentMenuView.draw(screen);
        }
        super.drawInternal(screen);
    }

    @Override
    protected void initInternal() {
        this.registerKeyBinding((Integer)0x100002, () -> this.left());
        this.registerKeyBinding((Integer)0x100003, () -> this.right());
        this.registerMouseBinding((Integer)65, event -> this.select((MouseEvent)event));
    }

    @Override
    public KeyHandler getKeyHandler() {
        KeyHandler handler = this.currentMenuView != null ? this.currentMenuView.getKeyHandler() : KeyHandler.neverConsume();
        return handler.thenIfNotConsumed(super.getKeyHandler());
    }

    @Override
    public MouseHandler getMouseHandler() {
        MouseHandler handler = this.currentMenuView != null ? this.currentMenuView.getMouseHandler() : MouseHandler.neverConsume();
        return handler.thenIfNotConsumed(super.getMouseHandler());
    }

    public List<MenuBarItem> getItems() {
        return this.items;
    }

    public void setSelected(int index) {
        this.activeItemIndex = index >= this.items.size() || index < 0 ? -1 : index;
    }

    private void left() {
        if (this.activeItemIndex > 0) {
            this.setSelected(this.activeItemIndex - 1);
            this.checkMenuView();
        }
    }

    private void right() {
        if (this.activeItemIndex + 1 < this.items.size()) {
            this.setSelected(this.activeItemIndex + 1);
            this.checkMenuView();
        }
    }

    private int indexAtPosition(int x, int y) {
        Rectangle rect = this.getRect();
        if (!rect.contains(x, y)) {
            return -1;
        }
        int i = 0;
        int p = 1;
        for (MenuBarItem item : this.items) {
            if (x < (p += item.getTitle().length() + 1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int positionAtIndex(int index) {
        int i = 0;
        int x = 1;
        for (MenuBarItem item : this.items) {
            if (i == index) {
                return x;
            }
            x += item.getTitle().length() + 1;
            ++i;
        }
        return x;
    }

    private int itemIndex(MenuBarItem item) {
        int index = 0;
        for (MenuBarItem i : this.items) {
            if (i == item) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void select(MouseEvent event) {
        int y;
        int x = event.x();
        int i = this.indexAtPosition(x, y = event.y());
        if (i > -1) {
            if (i == this.activeItemIndex) {
                this.setSelected(-1);
            } else {
                this.setSelected(i);
            }
        }
        this.checkMenuView();
    }

    @Override
    public void setThemeName(@Nullable String themeName) {
        super.setThemeName(themeName);
        this.menuViews.values().forEach(view -> view.setThemeName(themeName));
    }

    @Override
    public void setThemeResolver(@Nullable ThemeResolver themeResolver) {
        super.setThemeResolver(themeResolver);
        this.menuViews.values().forEach(view -> view.setThemeResolver(themeResolver));
    }

    private void checkMenuView() {
        if (this.activeItemIndex < 0) {
            this.closeCurrentMenuView();
        } else {
            MenuBarItem item = this.items.get(this.activeItemIndex);
            this.currentMenuView = this.menuViews.computeIfAbsent(item, i -> this.buildMenuView((MenuBarItem)i));
        }
    }

    private void closeCurrentMenuView() {
        this.currentMenuView = null;
    }

    private MenuView buildMenuView(MenuBarItem item) {
        EventLoop eventLoop = this.getEventLoop();
        MenuView menuView = new MenuView(item.getItems());
        menuView.init();
        menuView.setEventLoop(eventLoop);
        menuView.setThemeResolver(this.getThemeResolver());
        menuView.setThemeName(this.getThemeName());
        menuView.setViewService(this.getViewService());
        menuView.setShowBorder(true);
        menuView.setLayer(1);
        Rectangle rect = this.getInnerRect();
        int x = this.positionAtIndex(this.activeItemIndex);
        Dimension dim = menuView.getPreferredDimension();
        menuView.setRect(rect.x() + x, rect.y() + 1, dim.width(), dim.height());
        if (eventLoop != null) {
            menuView.onDestroy(eventLoop.viewEvents(MenuView.MenuViewOpenSelectedItemEvent.class, (View)menuView).subscribe(event -> this.closeCurrentMenuView()));
        }
        return menuView;
    }

    public void setItems(List<MenuBarItem> items) {
        this.items.clear();
        this.items.addAll(items);
        this.registerHotKeys();
    }

    private void selectItem(MenuBarItem item) {
        int index = this.itemIndex(item);
        if (index > -1) {
            this.setSelected(index);
            this.checkMenuView();
        }
    }

    private void registerHotKeys() {
        this.getItems().stream().filter(item -> item.getHotKey() != null).forEach(item -> this.registerHotKeyBinding(item.getHotKey(), () -> this.selectItem((MenuBarItem)item)));
    }

    public static class MenuBarItem {
        private String title;
        private List<MenuView.MenuItem> items;
        private @Nullable Integer hotKey;

        public MenuBarItem(String title) {
            this(title, null);
        }

        public MenuBarItem(String title, MenuView.MenuItem @Nullable [] items) {
            this.title = title;
            this.items = items == null ? List.of() : Arrays.asList(items);
        }

        public static MenuBarItem of(String title, MenuView.MenuItem ... items) {
            return new MenuBarItem(title, items);
        }

        public String getTitle() {
            return this.title;
        }

        public List<MenuView.MenuItem> getItems() {
            return this.items;
        }

        public @Nullable Integer getHotKey() {
            return this.hotKey;
        }

        public MenuBarItem setHotKey(Integer hotKey) {
            this.hotKey = hotKey;
            return this;
        }
    }
}

