/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import java.util.Optional;
import org.jline.utils.AttributedStyle;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.view.control.Control;
import org.springframework.shell.jline.tui.component.view.control.Spinner;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.shell.jline.tui.style.ThemeResolver;

public abstract class AbstractControl
implements Control {
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private @Nullable ThemeResolver themeResolver;
    private @Nullable String themeName;

    @Override
    public void setRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void setThemeResolver(@Nullable ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
    }

    protected @Nullable ThemeResolver getThemeResolver() {
        return this.themeResolver;
    }

    @Override
    public void setThemeName(@Nullable String themeName) {
        this.themeName = themeName;
    }

    protected @Nullable String getThemeName() {
        return this.themeName;
    }

    private Optional<ThemeResolver.ResolvedValues> getThemeResolvedValues(String tag) {
        ThemeResolver themeResolver = this.getThemeResolver();
        if (themeResolver != null) {
            String styleTag = themeResolver.resolveStyleTag(tag, this.getThemeName());
            AttributedStyle attributedStyle = themeResolver.resolveStyle(styleTag);
            return Optional.of(ThemeResolver.resolveValues(attributedStyle));
        }
        return Optional.empty();
    }

    protected int resolveThemeStyle(String tag, int defaultStyle) {
        return this.getThemeResolvedValues(tag).map(ThemeResolver.ResolvedValues::style).orElse(defaultStyle);
    }

    protected int resolveThemeForeground(String tag, int defaultColor, int fallbackColor) {
        if (defaultColor > -1) {
            return defaultColor;
        }
        return this.getThemeResolvedValues(tag).map(ThemeResolver.ResolvedValues::foreground).orElse(fallbackColor);
    }

    protected int resolveThemeBackground(String tag, int defaultColor, int fallbackColor) {
        if (defaultColor > -1) {
            return defaultColor;
        }
        return this.getThemeResolvedValues(tag).map(ThemeResolver.ResolvedValues::background).orElse(fallbackColor);
    }

    protected Spinner resolveThemeSpinner(String tag, @Nullable Spinner defaultSpinner, Spinner fallbackSpinner) {
        if (defaultSpinner != null) {
            return defaultSpinner;
        }
        Spinner spinner = null;
        ThemeResolver themeResolver = this.getThemeResolver();
        if (themeResolver != null) {
            spinner = themeResolver.resolveSpinnerTag(tag);
        }
        if (spinner == null) {
            spinner = fallbackSpinner;
        }
        return spinner;
    }
}

