/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.support;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.InfoCmp;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.context.BaseComponentContext;
import org.springframework.shell.jline.tui.component.context.ComponentContext;
import org.springframework.shell.jline.tui.component.support.AbstractComponent;

public abstract class AbstractTextComponent<T, C extends TextComponentContext<T, C>>
extends AbstractComponent<C> {
    private final @Nullable String name;

    public AbstractTextComponent(Terminal terminal) {
        this(terminal, null);
    }

    public AbstractTextComponent(Terminal terminal, @Nullable String name) {
        this(terminal, name, null);
    }

    public AbstractTextComponent(Terminal terminal, @Nullable String name, @Nullable Function<C, List<AttributedString>> renderer) {
        super(terminal);
        this.name = name;
        this.setRenderer(renderer);
    }

    @Override
    protected void bindKeyMap(KeyMap<String> keyMap) {
        keyMap.bind((Object)"EXIT", (CharSequence)"\r");
        keyMap.bind((Object)"BACKSPACE", new CharSequence[]{KeyMap.del(), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_backspace)});
        for (char i = ' '; i < '\u007f'; i = (char)(i + '\u0001')) {
            keyMap.bind((Object)"CHAR", (CharSequence)Character.toString(i));
        }
        keyMap.setUnicode((Object)"UNICODE");
    }

    @Override
    protected C runInternal(C context) {
        if (this.hasTty()) {
            this.loop((ComponentContext<?>)context);
        }
        return context;
    }

    protected @Nullable String getName() {
        return this.name;
    }

    public static interface TextComponentContext<T, C extends TextComponentContext<T, C>>
    extends ComponentContext<C> {
        public @Nullable String getName();

        public void setName(@Nullable String var1);

        public @Nullable String getInput();

        public void setInput(@Nullable String var1);

        public @Nullable T getResultValue();

        public void setResultValue(@Nullable T var1);

        public @Nullable String getMessage();

        public void setMessage(@Nullable String var1);

        public void setMessage(String var1, MessageLevel var2);

        public MessageLevel getMessageLevel();

        public void setMessageLevel(MessageLevel var1);

        public static enum MessageLevel {
            INFO,
            WARN,
            ERROR;

        }
    }

    public static class BaseTextComponentContext<T, C extends TextComponentContext<T, C>>
    extends BaseComponentContext<C>
    implements TextComponentContext<T, C> {
        private @Nullable String name;
        private @Nullable String input;
        private @Nullable T resultValue;
        private @Nullable String message;
        private TextComponentContext.MessageLevel messageLevel = TextComponentContext.MessageLevel.INFO;

        @Override
        public @Nullable String getName() {
            return this.name;
        }

        @Override
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @Override
        public @Nullable String getInput() {
            return this.input;
        }

        @Override
        public void setInput(@Nullable String input) {
            this.input = input;
        }

        @Override
        public @Nullable T getResultValue() {
            return this.resultValue;
        }

        @Override
        public void setResultValue(@Nullable T resultValue) {
            this.resultValue = resultValue;
        }

        @Override
        public @Nullable String getMessage() {
            return this.message;
        }

        @Override
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @Override
        public void setMessage(String message, TextComponentContext.MessageLevel level) {
            this.setMessage(message);
            this.setMessageLevel(level);
        }

        @Override
        public TextComponentContext.MessageLevel getMessageLevel() {
            return this.messageLevel;
        }

        @Override
        public void setMessageLevel(TextComponentContext.MessageLevel messageLevel) {
            this.messageLevel = messageLevel;
        }

        @Override
        public Map<String, @Nullable Object> toTemplateModel() {
            Map<String, @Nullable Object> attributes = super.toTemplateModel();
            T value = this.getResultValue();
            attributes.put("resultValue", value != null ? value.toString() : null);
            attributes.put("name", this.getName());
            attributes.put("message", this.getMessage());
            attributes.put("messageLevel", (Object)this.getMessageLevel());
            attributes.put("hasMessageLevelInfo", this.getMessageLevel() == TextComponentContext.MessageLevel.INFO);
            attributes.put("hasMessageLevelWarn", this.getMessageLevel() == TextComponentContext.MessageLevel.WARN);
            attributes.put("hasMessageLevelError", this.getMessageLevel() == TextComponentContext.MessageLevel.ERROR);
            attributes.put("input", this.getInput());
            return attributes;
        }
    }
}

