/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.message;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.util.context.ContextView;

public class ShellMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String PRIORITY = "priority";
    public static final String VIEW = "view";
    public static final String REACTOR_CONTEXT = "reactorContext";
    public static final String EVENT_TYPE = "eventType";
    private static final BiFunction<String, String, String> TYPE_VERIFY_MESSAGE_FUNCTION = (name, trailer) -> "The '" + name + trailer;
    private Set<String> readOnlyHeaders = new HashSet<String>();

    public ShellMessageHeaderAccessor(@Nullable Message<?> message) {
        super(message);
    }

    public void setReadOnlyHeaders(String ... readOnlyHeaders) {
        Assert.noNullElements((Object[])readOnlyHeaders, (String)"'readOnlyHeaders' must not be contain null items.");
        if (!ObjectUtils.isEmpty((Object[])readOnlyHeaders)) {
            this.readOnlyHeaders = new HashSet<String>(Arrays.asList(readOnlyHeaders));
        }
    }

    public @Nullable Integer getPriority() {
        Number priority = this.getHeader(PRIORITY, Number.class);
        return priority != null ? Integer.valueOf(priority.intValue()) : null;
    }

    public @Nullable View getView() {
        View view = this.getHeader(VIEW, View.class);
        return view;
    }

    public @Nullable ContextView getReactorContext() {
        return this.getHeader(REACTOR_CONTEXT, ContextView.class);
    }

    public  @Nullable EventLoop.Type getEventType() {
        return this.getHeader(EVENT_TYPE, EventLoop.Type.class);
    }

    public <T> @Nullable T getHeader(String key, Class<T> type) {
        Object value = this.getHeader(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + String.valueOf(type) + "] but actual type is [" + String.valueOf(value.getClass()) + "]");
        }
        return (T)value;
    }

    protected void verifyType(@Nullable String headerName, @Nullable Object headerValue) {
        if (headerName != null && headerValue != null) {
            super.verifyType(headerName, headerValue);
            if (PRIORITY.equals(headerName)) {
                Assert.isTrue((boolean)Number.class.isAssignableFrom(headerValue.getClass()), (String)TYPE_VERIFY_MESSAGE_FUNCTION.apply(headerName, "' header value must be a Number."));
            }
        }
    }

    public boolean isReadOnly(String headerName) {
        return super.isReadOnly(headerName) || this.readOnlyHeaders.contains(headerName);
    }

    public Map<String, Object> toMap() {
        if (ObjectUtils.isEmpty(this.readOnlyHeaders)) {
            return super.toMap();
        }
        Map headers = super.toMap();
        for (String header : this.readOnlyHeaders) {
            headers.remove(header);
        }
        return headers;
    }
}

