/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.flow;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.terminal.Terminal;
import org.jspecify.annotations.Nullable;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.jline.tui.component.ConfirmationInput;
import org.springframework.shell.jline.tui.component.MultiItemSelector;
import org.springframework.shell.jline.tui.component.NumberInput;
import org.springframework.shell.jline.tui.component.PathInput;
import org.springframework.shell.jline.tui.component.SingleItemSelector;
import org.springframework.shell.jline.tui.component.StringInput;
import org.springframework.shell.jline.tui.component.context.ComponentContext;
import org.springframework.shell.jline.tui.component.flow.BaseConfirmationInput;
import org.springframework.shell.jline.tui.component.flow.BaseMultiItemSelector;
import org.springframework.shell.jline.tui.component.flow.BaseNumberInput;
import org.springframework.shell.jline.tui.component.flow.BasePathInput;
import org.springframework.shell.jline.tui.component.flow.BaseSingleItemSelector;
import org.springframework.shell.jline.tui.component.flow.BaseStringInput;
import org.springframework.shell.jline.tui.component.flow.ConfirmationInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultConfirmationInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultMultiInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultNumberInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultPathInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultSingleInputSpec;
import org.springframework.shell.jline.tui.component.flow.DefaultStringInputSpec;
import org.springframework.shell.jline.tui.component.flow.MultiItemSelectorSpec;
import org.springframework.shell.jline.tui.component.flow.NumberInputSpec;
import org.springframework.shell.jline.tui.component.flow.PathInputSpec;
import org.springframework.shell.jline.tui.component.flow.ResultMode;
import org.springframework.shell.jline.tui.component.flow.SingleItemSelectorSpec;
import org.springframework.shell.jline.tui.component.flow.StringInputSpec;
import org.springframework.shell.jline.tui.component.support.SelectorItem;
import org.springframework.shell.jline.tui.style.TemplateExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public interface ComponentFlow {
    public ComponentFlowResult run();

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static class DefaultBuilder
    extends BaseBuilder {
        DefaultBuilder() {
        }

        DefaultBuilder(BaseBuilder other) {
            this.terminal(other.getTerminal());
            this.resourceLoader(other.getResourceLoader());
            this.templateExecutor(other.getTemplateExecutor());
        }
    }

    public static class OrderedInputOperation
    implements Ordered {
        private @Nullable String id;
        private int order;
        private @Nullable Function<ComponentContext<?>, ComponentContext<?>> operation;
        private @Nullable Function<ComponentContext<?>, Optional<String>> next;

        public int getOrder() {
            return this.order;
        }

        public @Nullable String getId() {
            return this.id;
        }

        public @Nullable Function<ComponentContext<?>, ComponentContext<?>> getOperation() {
            return this.operation;
        }

        public @Nullable Function<ComponentContext<?>, Optional<String>> getNext() {
            return this.next;
        }

        static OrderedInputOperation of(String id, int order, Function<ComponentContext<?>, ComponentContext<?>> operation, Function<ComponentContext<?>, Optional<String>> next) {
            OrderedInputOperation oio = new OrderedInputOperation();
            oio.id = id;
            oio.order = order;
            oio.operation = operation;
            oio.next = next;
            return oio;
        }
    }

    public static class DefaultComponentFlow
    implements ComponentFlow {
        private static final Log log = LogFactory.getLog(DefaultComponentFlow.class);
        private final Terminal terminal;
        private final List<BaseStringInput> stringInputs;
        private final List<BaseNumberInput> numberInputs;
        private final List<BasePathInput> pathInputs;
        private final List<BaseConfirmationInput> confirmationInputs;
        private final List<BaseSingleItemSelector> singleInputs;
        private final List<BaseMultiItemSelector> multiInputs;
        private final @Nullable ResourceLoader resourceLoader;
        private final @Nullable TemplateExecutor templateExecutor;

        DefaultComponentFlow(@Nullable Terminal terminal, @Nullable ResourceLoader resourceLoader, @Nullable TemplateExecutor templateExecutor, List<BaseStringInput> stringInputs, List<BaseNumberInput> numberInputs, List<BasePathInput> pathInputs, List<BaseConfirmationInput> confirmationInputs, List<BaseSingleItemSelector> singleInputs, List<BaseMultiItemSelector> multiInputs) {
            Assert.state((terminal != null ? 1 : 0) != 0, (String)"'terminal' must not be null");
            this.terminal = terminal;
            this.resourceLoader = resourceLoader;
            this.templateExecutor = templateExecutor;
            this.stringInputs = stringInputs;
            this.numberInputs = numberInputs;
            this.pathInputs = pathInputs;
            this.confirmationInputs = confirmationInputs;
            this.singleInputs = singleInputs;
            this.multiInputs = multiInputs;
        }

        @Override
        public ComponentFlowResult run() {
            return this.runGetResults();
        }

        private DefaultComponentFlowResult runGetResults() {
            List<OrderedInputOperation> oios = Stream.of(this.stringInputsStream(), this.numberInputsStream(), this.pathInputsStream(), this.confirmationInputsStream(), this.singleItemSelectorsStream(), this.multiItemSelectorsStream()).flatMap(oio -> oio).sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
            OrderedInputOperationList oiol = new OrderedInputOperationList(oios);
            ComponentContext<Object> context = ComponentContext.empty();
            OrderedInputOperationList.Node node = oiol.getFirst();
            while (node != null) {
                log.debug((Object)("Calling apply for " + node.data.id));
                Function<ComponentContext<?>, ComponentContext<?>> operation = node.data.getOperation();
                if (operation != null) {
                    context = operation.apply(context);
                }
                if (node.data.next != null) {
                    Optional<String> n = node.data.next.apply(context);
                    if (n == null) {
                        node = node.next;
                        continue;
                    }
                    if (n.isPresent()) {
                        node = oiol.get(n.get());
                        continue;
                    }
                    node = null;
                    continue;
                }
                node = node.next;
            }
            return new DefaultComponentFlowResult(context);
        }

        private Stream<OrderedInputOperation> stringInputsStream() {
            return this.stringInputs.stream().map(input -> {
                StringInput selector = new StringInput(this.terminal, input.getName(), input.getDefaultValue(), null, input.isRequired());
                Function<ComponentContext<?>, ComponentContext<?>> operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && StringUtils.hasText((String)input.getResultValue())) {
                        context.put(input.getId(), input.getResultValue());
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    selector.setMaskCharacter(input.getMaskCharacter());
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.isStoreResult()) {
                        if (input.getResultMode() == ResultMode.VERIFY && StringUtils.hasText((String)input.getResultValue())) {
                            selector.addPreRunHandler(c -> {
                                c.setDefaultValue(input.getResultValue());
                                c.setRequired(input.isRequired());
                            });
                        }
                        selector.addPostRunHandler(c -> {
                            String resultValue = (String)c.getResultValue();
                            if (resultValue != null) {
                                c.put(input.getId(), resultValue);
                            }
                        });
                    }
                    for (Consumer<StringInput.StringInputContext> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<StringInput.StringInputContext> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<StringInput.StringInputContext, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((StringInput.StringInputContext)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private Stream<OrderedInputOperation> numberInputsStream() {
            return this.numberInputs.stream().map(input -> {
                NumberInput selector = new NumberInput(this.terminal, input.getName(), input.getDefaultValue(), input.getNumberClass(), input.isRequired());
                UnaryOperator operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && input.getResultValue() != null) {
                        context.put(input.getId(), input.getResultValue());
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    selector.setNumberClass(input.getNumberClass());
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.isStoreResult()) {
                        if (input.getResultMode() == ResultMode.VERIFY && input.getResultValue() != null) {
                            selector.addPreRunHandler(c -> {
                                c.setDefaultValue(input.getResultValue());
                                c.setRequired(input.isRequired());
                            });
                        }
                        selector.addPostRunHandler(c -> {
                            Number result = (Number)c.getResultValue();
                            if (result != null) {
                                c.put(input.getId(), c.getResultValue());
                            }
                        });
                    }
                    for (Consumer<NumberInput.NumberInputContext> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<NumberInput.NumberInputContext> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<NumberInput.NumberInputContext, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((NumberInput.NumberInputContext)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private Stream<OrderedInputOperation> pathInputsStream() {
            return this.pathInputs.stream().map(input -> {
                PathInput selector = new PathInput(this.terminal, input.getName());
                Function<ComponentContext<?>, ComponentContext<?>> operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && StringUtils.hasText((String)input.getResultValue())) {
                        context.put(input.getId(), Paths.get(input.getResultValue(), new String[0]));
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.isStoreResult()) {
                        selector.addPostRunHandler(c -> {
                            Path resultValue = (Path)c.getResultValue();
                            if (resultValue != null) {
                                c.put(input.getId(), resultValue);
                            }
                        });
                    }
                    for (Consumer<PathInput.PathInputContext> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<PathInput.PathInputContext> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<PathInput.PathInputContext, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((PathInput.PathInputContext)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private Stream<OrderedInputOperation> confirmationInputsStream() {
            return this.confirmationInputs.stream().map(input -> {
                ConfirmationInput selector = new ConfirmationInput(this.terminal, input.getName(), input.getDefaultValue());
                Function<ComponentContext<?>, ComponentContext<?>> operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && input.getResultValue() != null) {
                        context.put(input.getId(), input.getResultValue());
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.isStoreResult()) {
                        selector.addPostRunHandler(c -> {
                            if (c.getResultValue() != null) {
                                c.put(input.getId(), c.getResultValue());
                            }
                        });
                    }
                    for (Consumer<ConfirmationInput.ConfirmationInputContext> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<ConfirmationInput.ConfirmationInputContext> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<ConfirmationInput.ConfirmationInputContext, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((ConfirmationInput.ConfirmationInputContext)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private Stream<OrderedInputOperation> singleItemSelectorsStream() {
            return this.singleInputs.stream().map(input -> {
                List selectorItems = input.getSelectItems().stream().map(si -> SelectorItem.of(si.name(), si.item())).collect(Collectors.toList());
                String defaultSelect = input.getDefaultSelect();
                Stream<Object> defaultCheckStream = StringUtils.hasText((String)defaultSelect) ? selectorItems.stream() : Stream.empty();
                SelectorItem defaultExpose = defaultCheckStream.filter(si -> ObjectUtils.nullSafeEquals((Object)defaultSelect, (Object)si.getName())).findFirst().orElse(null);
                SingleItemSelector selector = new SingleItemSelector(this.terminal, selectorItems, input.getName(), input.getComparator());
                selector.setDefaultExpose(defaultExpose);
                Function<ComponentContext<?>, ComponentContext<?>> operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && StringUtils.hasText((String)input.getResultValue())) {
                        context.put(input.getId(), input.getResultValue());
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.getMaxItems() != null) {
                        selector.setMaxItems(input.getMaxItems());
                    }
                    if (input.isStoreResult()) {
                        selector.addPostRunHandler(c -> c.getValue().ifPresent(v -> c.put(input.getId(), v)));
                    }
                    for (Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private Stream<OrderedInputOperation> multiItemSelectorsStream() {
            return this.multiInputs.stream().map(input -> {
                List selectorItems = input.getSelectItems().stream().map(si -> SelectorItem.of(si.name(), si.item(), si.enabled(), si.selected())).collect(Collectors.toList());
                MultiItemSelector selector = new MultiItemSelector(this.terminal, selectorItems, input.getName(), input.getComparator());
                Function<ComponentContext<?>, ComponentContext<?>> operation = context -> {
                    if (input.getResultMode() == ResultMode.ACCEPT && input.isStoreResult() && !ObjectUtils.isEmpty(input.getResultValues())) {
                        context.put(input.getId(), input.getResultValues());
                        return context;
                    }
                    if (this.resourceLoader != null) {
                        selector.setResourceLoader(this.resourceLoader);
                    }
                    if (this.templateExecutor != null) {
                        selector.setTemplateExecutor(this.templateExecutor);
                    }
                    if (StringUtils.hasText((String)input.getTemplateLocation())) {
                        selector.setTemplateLocation(input.getTemplateLocation());
                    }
                    if (input.getRenderer() != null) {
                        selector.setRenderer(input.getRenderer());
                    }
                    if (input.getMaxItems() != null) {
                        selector.setMaxItems(input.getMaxItems());
                    }
                    if (input.isStoreResult()) {
                        selector.addPostRunHandler(c -> c.put(input.getId(), c.getValues()));
                    }
                    for (Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>> handler : input.getPreHandlers()) {
                        selector.addPreRunHandler(handler);
                    }
                    for (Consumer<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>> handler : input.getPostHandlers()) {
                        selector.addPostRunHandler(handler);
                    }
                    return selector.run((ComponentContext<?>)context);
                };
                Function<MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>, String> f1 = input.getNext();
                Function<ComponentContext<?>, Optional<String>> f2 = context -> f1 != null ? Optional.ofNullable((String)f1.apply((MultiItemSelector.MultiItemSelectorContext<String, SelectorItem<String>>)selector.getThisContext((ComponentContext)context))) : null;
                return OrderedInputOperation.of(input.getId(), input.getOrder(), operation, f2);
            });
        }

        private static class OrderedInputOperationList {
            private final Map<String, Node> map = new HashMap<String, Node>();
            private @Nullable Node first;

            OrderedInputOperationList(List<OrderedInputOperation> values) {
                Node ref = null;
                for (OrderedInputOperation oio : values) {
                    Node node = new Node(oio);
                    this.map.put(oio.id, node);
                    if (ref != null) {
                        ref.next = node;
                    }
                    ref = node;
                    if (this.first != null) continue;
                    this.first = node;
                }
            }

            @Nullable Node get(String id) {
                return this.map.get(id);
            }

            @Nullable Node getFirst() {
                return this.first;
            }

            static class Node {
                OrderedInputOperation data;
                @Nullable Node next;

                Node(OrderedInputOperation data) {
                    this.data = data;
                }
            }
        }
    }

    public static class DefaultComponentFlowResult
    implements ComponentFlowResult {
        private ComponentContext<?> context;

        DefaultComponentFlowResult(ComponentContext<?> context) {
            this.context = context;
        }

        @Override
        public ComponentContext<?> getContext() {
            return this.context;
        }
    }

    public static abstract class BaseBuilder
    implements Builder {
        private final List<BaseStringInput> stringInputs = new ArrayList<BaseStringInput>();
        private final List<BaseNumberInput> numberInputs = new ArrayList<BaseNumberInput>();
        private final List<BasePathInput> pathInputs = new ArrayList<BasePathInput>();
        private final List<BaseConfirmationInput> confirmationInputs = new ArrayList<BaseConfirmationInput>();
        private final List<BaseSingleItemSelector> singleItemSelectors = new ArrayList<BaseSingleItemSelector>();
        private final List<BaseMultiItemSelector> multiItemSelectors = new ArrayList<BaseMultiItemSelector>();
        private final AtomicInteger order = new AtomicInteger();
        private final HashSet<String> uniqueIds = new HashSet();
        private @Nullable Terminal terminal;
        private @Nullable ResourceLoader resourceLoader;
        private @Nullable TemplateExecutor templateExecutor;

        BaseBuilder() {
        }

        @Override
        public ComponentFlow build() {
            return new DefaultComponentFlow(this.terminal, this.resourceLoader, this.templateExecutor, this.stringInputs, this.numberInputs, this.pathInputs, this.confirmationInputs, this.singleItemSelectors, this.multiItemSelectors);
        }

        @Override
        public StringInputSpec withStringInput(String id) {
            return new DefaultStringInputSpec(this, id);
        }

        @Override
        public NumberInputSpec withNumberInput(String id) {
            return new DefaultNumberInputSpec(this, id);
        }

        @Override
        public PathInputSpec withPathInput(String id) {
            return new DefaultPathInputSpec(this, id);
        }

        @Override
        public ConfirmationInputSpec withConfirmationInput(String id) {
            return new DefaultConfirmationInputSpec(this, id);
        }

        @Override
        public SingleItemSelectorSpec withSingleItemSelector(String id) {
            return new DefaultSingleInputSpec(this, id);
        }

        @Override
        public MultiItemSelectorSpec withMultiItemSelector(String id) {
            return new DefaultMultiInputSpec(this, id);
        }

        @Override
        public Builder terminal(@Nullable Terminal terminal) {
            this.terminal = terminal;
            return this;
        }

        @Override
        public Builder resourceLoader(@Nullable ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        @Override
        public Builder templateExecutor(@Nullable TemplateExecutor templateExecutor) {
            this.templateExecutor = templateExecutor;
            return this;
        }

        @Override
        public Builder clone() {
            return new DefaultBuilder(this);
        }

        @Override
        public Builder reset() {
            this.stringInputs.clear();
            this.numberInputs.clear();
            this.pathInputs.clear();
            this.confirmationInputs.clear();
            this.singleItemSelectors.clear();
            this.multiItemSelectors.clear();
            this.order.set(0);
            this.uniqueIds.clear();
            return this;
        }

        void addStringInput(BaseStringInput input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.stringInputs.add(input);
        }

        void addNumberInput(BaseNumberInput input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.numberInputs.add(input);
        }

        void addPathInput(BasePathInput input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.pathInputs.add(input);
        }

        void addConfirmationInput(BaseConfirmationInput input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.confirmationInputs.add(input);
        }

        void addSingleItemSelector(BaseSingleItemSelector input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.singleItemSelectors.add(input);
        }

        void addMultiItemSelector(BaseMultiItemSelector input) {
            this.checkUniqueId(input.getId());
            input.setOrder(this.order.getAndIncrement());
            this.multiItemSelectors.add(input);
        }

        @Nullable Terminal getTerminal() {
            return this.terminal;
        }

        @Nullable ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        @Nullable TemplateExecutor getTemplateExecutor() {
            return this.templateExecutor;
        }

        private void checkUniqueId(String id) {
            if (this.uniqueIds.contains(id)) {
                throw new IllegalArgumentException(String.format("Component with id %s is already registered", id));
            }
            this.uniqueIds.add(id);
        }
    }

    public static interface Builder {
        public StringInputSpec withStringInput(String var1);

        public NumberInputSpec withNumberInput(String var1);

        public PathInputSpec withPathInput(String var1);

        public ConfirmationInputSpec withConfirmationInput(String var1);

        public SingleItemSelectorSpec withSingleItemSelector(String var1);

        public MultiItemSelectorSpec withMultiItemSelector(String var1);

        public Builder terminal(@Nullable Terminal var1);

        public Builder resourceLoader(@Nullable ResourceLoader var1);

        public Builder templateExecutor(@Nullable TemplateExecutor var1);

        public Builder clone();

        public Builder reset();

        public ComponentFlow build();
    }

    public static interface ComponentFlowResult {
        public ComponentContext<?> getContext();
    }
}

