/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.context.ComponentContext;
import org.springframework.shell.jline.tui.component.support.AbstractTextComponent;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class NumberInput
extends AbstractTextComponent<Number, NumberInputContext> {
    private static final Log log = LogFactory.getLog(NumberInput.class);
    private final @Nullable Number defaultValue;
    private @Nullable NumberInputContext currentContext;
    private Class<? extends Number> clazz;
    private boolean required;

    public NumberInput(Terminal terminal) {
        this(terminal, null);
    }

    public NumberInput(Terminal terminal, @Nullable String name) {
        this(terminal, name, (Number)null);
    }

    public NumberInput(Terminal terminal, @Nullable String name, @Nullable Number defaultValue) {
        this(terminal, name, defaultValue, Integer.class);
    }

    public NumberInput(Terminal terminal, @Nullable String name, @Nullable Number defaultValue, Class<? extends Number> clazz) {
        this(terminal, name, defaultValue, clazz, false);
    }

    public NumberInput(Terminal terminal, @Nullable String name, @Nullable Number defaultValue, Class<? extends Number> clazz, boolean required) {
        this(terminal, name, defaultValue, clazz, required, null);
    }

    public NumberInput(Terminal terminal, @Nullable String name, @Nullable Number defaultValue, Class<? extends Number> clazz, boolean required, @Nullable Function<NumberInputContext, List<AttributedString>> renderer) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/number-input-default.stg");
        this.defaultValue = defaultValue;
        this.clazz = clazz;
        this.required = required;
    }

    public void setNumberClass(Class<? extends Number> clazz) {
        this.clazz = clazz;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public NumberInputContext getThisContext(@Nullable ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = NumberInputContext.of(this.defaultValue, this.clazz, this.required);
        this.currentContext.setName(this.getName());
        Optional.ofNullable(context).map(ComponentContext::stream).ifPresent(entryStream -> entryStream.forEach(e -> this.currentContext.put(e.getKey(), e.getValue())));
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, NumberInputContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug((Object)("Binding read result " + operation));
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = context.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                context.setInput((String)input);
                this.checkInput((String)input, context);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                context.setInput(input);
                this.checkInput(input, context);
                break;
            }
            case "EXIT": {
                Number num = this.parseNumber(context.getInput());
                if (num != null) {
                    context.setResultValue(this.parseNumber(context.getInput()));
                } else {
                    if (StringUtils.hasText((String)context.getInput())) {
                        this.printInvalidInput(context.getInput(), context);
                        break;
                    }
                    if (context.getDefaultValue() != null) {
                        context.setResultValue(context.getDefaultValue());
                    } else if (this.required) {
                        context.setMessage("This field is mandatory", AbstractTextComponent.TextComponentContext.MessageLevel.ERROR);
                        break;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private Number parseNumber(String input) {
        if (!StringUtils.hasText((String)input)) {
            return null;
        }
        try {
            return NumberUtils.parseNumber((String)input, this.clazz);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void checkInput(String input, NumberInputContext context) {
        if (!StringUtils.hasText((String)input)) {
            context.setMessage(null);
            return;
        }
        Number num = this.parseNumber(input);
        if (num == null) {
            this.printInvalidInput(input, context);
        } else {
            context.setMessage(null);
        }
    }

    private void printInvalidInput(String input, NumberInputContext context) {
        String msg = String.format("Sorry, your input is invalid: '%s', try again", input);
        context.setMessage(msg, AbstractTextComponent.TextComponentContext.MessageLevel.ERROR);
    }

    private class DefaultRenderer
    implements Function<NumberInputContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(NumberInputContext context) {
            return NumberInput.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    public static interface NumberInputContext
    extends AbstractTextComponent.TextComponentContext<Number, NumberInputContext> {
        public @Nullable Number getDefaultValue();

        public void setDefaultValue(@Nullable Number var1);

        public Class<? extends Number> getDefaultClass();

        public void setDefaultClass(Class<? extends Number> var1);

        public void setRequired(boolean var1);

        public boolean isRequired();

        public static NumberInputContext empty() {
            return NumberInputContext.of(null);
        }

        public static NumberInputContext of(@Nullable Number defaultValue) {
            return new DefaultNumberInputContext(defaultValue, Integer.class, false);
        }

        public static NumberInputContext of(@Nullable Number defaultValue, Class<? extends Number> defaultClass) {
            return new DefaultNumberInputContext(defaultValue, defaultClass, false);
        }

        public static NumberInputContext of(@Nullable Number defaultValue, Class<? extends Number> defaultClass, boolean required) {
            return new DefaultNumberInputContext(defaultValue, defaultClass, required);
        }
    }

    private static class DefaultNumberInputContext
    extends AbstractTextComponent.BaseTextComponentContext<Number, NumberInputContext>
    implements NumberInputContext {
        private @Nullable Number defaultValue;
        private Class<? extends Number> defaultClass;
        private boolean required;

        public DefaultNumberInputContext(@Nullable Number defaultValue, Class<? extends Number> defaultClass, boolean required) {
            this.defaultValue = defaultValue;
            this.defaultClass = defaultClass;
            this.required = required;
        }

        @Override
        public @Nullable Number getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(@Nullable Number defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Class<? extends Number> getDefaultClass() {
            return this.defaultClass;
        }

        @Override
        public void setDefaultClass(Class<? extends Number> defaultClass) {
            this.defaultClass = defaultClass;
        }

        @Override
        public void setRequired(boolean required) {
            this.required = required;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Map<String, @Nullable Object> toTemplateModel() {
            Map<String, @Nullable Object> attributes = super.toTemplateModel();
            attributes.put("defaultValue", this.getDefaultValue() != null ? (Number)this.getDefaultValue() : (Number)null);
            attributes.put("defaultClass", this.getDefaultClass().getSimpleName());
            attributes.put("required", this.isRequired());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }
    }
}

