/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.core.command.Clear;
import org.springframework.shell.core.command.Command;
import org.springframework.shell.core.command.Help;
import org.springframework.shell.core.command.Version;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class StandardCommandsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.shell.command.help.enabled"}, havingValue="true", matchIfMissing=true)
    public Command helpCommand() {
        return new Help();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.shell.command.clear.enabled"}, havingValue="true", matchIfMissing=true)
    public Command clearCommand() {
        return new Clear();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.shell.command.version.enabled"}, havingValue="true", matchIfMissing=true)
    public Command versionCommand() {
        return new Version();
    }
}

