/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.boot.TerminalCustomizer;
import org.springframework.shell.core.command.Command;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.config.UserConfigPathProvider;
import org.springframework.shell.jline.CommandCompleter;
import org.springframework.shell.jline.ExtendedDefaultParser;
import org.springframework.shell.jline.JLineInputProvider;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class JLineShellAutoConfiguration {
    private static final Log log = LogFactory.getLog(JLineShellAutoConfiguration.class);
    private History jLineHistory;
    @Value(value="${spring.application.name:spring-shell}.log")
    private String fallbackHistoryFileName = "spring-shell.log";
    private SpringShellProperties springShellProperties;
    private UserConfigPathProvider userConfigPathProvider;

    public JLineShellAutoConfiguration(History jLineHistory, SpringShellProperties springShellProperties, UserConfigPathProvider userConfigPathProvider) {
        this.jLineHistory = jLineHistory;
        this.springShellProperties = springShellProperties;
        this.userConfigPathProvider = userConfigPathProvider;
    }

    @EventListener
    public void onContextClosedEvent(ContextClosedEvent event) throws IOException {
        this.jLineHistory.save();
    }

    @Bean
    public LineReader lineReader(Terminal terminal, Parser parser, CommandCompleter commandCompleter, final CommandRegistry commandRegistry) {
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(terminal).appName("Spring Shell").completer((Completer)commandCompleter).history(this.jLineHistory).highlighter(new Highlighter(){

            public AttributedString highlight(LineReader reader, String buffer) {
                int l = 0;
                String best = null;
                for (Command command : commandRegistry.getCommands()) {
                    if (!buffer.startsWith(command.getName()) || command.getName().length() <= l) continue;
                    l = command.getName().length();
                    best = command.getName();
                }
                if (best != null) {
                    return new AttributedStringBuilder(buffer.length()).append(best, AttributedStyle.BOLD).append((CharSequence)buffer.substring(l)).toAttributedString();
                }
                return new AttributedString((CharSequence)buffer, AttributedStyle.DEFAULT.foreground(1));
            }

            public void setErrorPattern(Pattern errorPattern) {
            }

            public void setErrorIndex(int errorIndex) {
            }
        }).parser(parser);
        LineReader lineReader = lineReaderBuilder.build();
        if (this.springShellProperties.getHistory().isEnabled()) {
            Path userConfigPath = this.userConfigPathProvider.provide();
            log.debug((Object)("Resolved userConfigPath " + String.valueOf(userConfigPath)));
            String historyFileName = this.springShellProperties.getHistory().getName();
            if (!StringUtils.hasText((String)historyFileName)) {
                historyFileName = this.fallbackHistoryFileName;
            }
            log.debug((Object)("Resolved historyFileName " + historyFileName));
            String historyPath = userConfigPath.resolve(historyFileName).toAbsolutePath().toString();
            log.debug((Object)("Resolved historyPath " + historyPath));
            lineReader.setVariable("history-file", (Object)Paths.get(historyPath, new String[0]));
        }
        lineReader.unsetOpt(LineReader.Option.INSERT_TAB);
        this.jLineHistory.attach(lineReader);
        return lineReader;
    }

    @Bean
    public JLineInputProvider inputProvider(LineReader lineReader) {
        return new JLineInputProvider(lineReader);
    }

    @Bean(destroyMethod="close")
    public Terminal terminal(ObjectProvider<TerminalCustomizer> customizers) {
        try {
            TerminalBuilder builder = TerminalBuilder.builder();
            builder.systemOutput(TerminalBuilder.SystemOutput.SysOut);
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        }
        catch (IOException e) {
            throw new BeanCreationException("Could not create Terminal", (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={PromptProvider.class})
    public PromptProvider promptProvider() {
        return () -> new AttributedString((CharSequence)"shell:>", AttributedStyle.DEFAULT.foreground(3));
    }

    @Bean
    public Parser parser() {
        ExtendedDefaultParser parser = new ExtendedDefaultParser();
        parser.setEofOnUnclosedQuote(true);
        parser.setEofOnEscapedNewLine(true);
        return parser;
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandCompleter commandCompleter(CommandRegistry commandRegistry) {
        return new CommandCompleter(commandRegistry);
    }

    @Configuration
    @ConditionalOnMissingBean(value={History.class})
    public static class JLineHistoryConfiguration {
        @Bean
        public History history() {
            return new DefaultHistory();
        }
    }
}

