/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.boot.SpringShellProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class ApplicationRunnerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.shell.context", name={"close"}, havingValue="true")
    public ApplicationReadyEventListener applicationReadyEventListener() {
        return new ApplicationReadyEventListener();
    }

    static class ApplicationReadyEventListener
    implements ApplicationListener<ApplicationReadyEvent> {
        ApplicationReadyEventListener() {
        }

        public void onApplicationEvent(ApplicationReadyEvent event) {
            event.getApplicationContext().close();
        }
    }
}

