/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.core.ConsoleInputProvider;
import org.springframework.shell.core.NonInteractiveShellRunner;
import org.springframework.shell.core.ShellRunner;
import org.springframework.shell.core.SystemShellRunner;
import org.springframework.shell.core.command.CommandParser;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.DefaultCommandParser;
import org.springframework.shell.jline.JLineInputProvider;
import org.springframework.shell.jline.JLineShellRunner;

@AutoConfiguration
public class ShellRunnerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationRunner springShellApplicationRunner(ShellRunner shellRunner) {
        return args -> shellRunner.run(args.getSourceArgs());
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.shell.jline.DefaultJLineShellConfiguration"})
    public ShellRunner systemShellRunner(ConsoleInputProvider consoleInputProvider, CommandParser commandParser, CommandRegistry commandRegistry) {
        return new SystemShellRunner(consoleInputProvider, commandParser, commandRegistry);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.shell.jline.JLineInputProvider"})
    public ShellRunner jlineShellRunner(JLineInputProvider inputProvider, CommandParser commandParser, CommandRegistry commandRegistry) {
        return new JLineShellRunner(inputProvider, commandParser, commandRegistry);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.interactive", name={"enabled"}, havingValue="false")
    public ShellRunner nonInteractiveShellRunner(CommandParser commandParser, CommandRegistry commandRegistry) {
        return new NonInteractiveShellRunner(commandParser, commandRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsoleInputProvider consoleInputProvider() {
        return new ConsoleInputProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandParser commandParser() {
        return new DefaultCommandParser();
    }
}

