/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.shell.boot.SpringShellAutoConfiguration;
import org.springframework.shell.core.ShellConfigurationException;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.annotation.Command;
import org.springframework.shell.core.command.annotation.support.CommandFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@AutoConfiguration
public class CommandRegistryAutoConfiguration {
    private static final Log log = LogFactory.getLog(SpringShellAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CommandRegistry commandRegistry(ApplicationContext applicationContext) {
        CommandRegistry commandRegistry = new CommandRegistry();
        this.registerProgrammaticCommands(applicationContext, commandRegistry);
        this.registerAnnotatedCommands(applicationContext, commandRegistry);
        return commandRegistry;
    }

    private void registerProgrammaticCommands(ApplicationContext applicationContext, CommandRegistry commandRegistry) {
        Map commandBeans = applicationContext.getBeansOfType(org.springframework.shell.core.command.Command.class);
        commandBeans.values().forEach(arg_0 -> ((CommandRegistry)commandRegistry).registerCommand(arg_0));
    }

    private void registerAnnotatedCommands(ApplicationContext applicationContext, CommandRegistry commandRegistry) {
        Map springBootApps = applicationContext.getBeansWithAnnotation(SpringBootApplication.class);
        Class mainClass = AopUtils.getTargetClass(springBootApps.values().iterator().next());
        String mainPackage = ClassUtils.getPackageName((Class)mainClass);
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
        Set candidateComponents = scanner.findCandidateComponents(mainPackage);
        for (BeanDefinition candidateComponent : candidateComponents) {
            String className = candidateComponent.getBeanClassName();
            if (className == null) {
                log.warn((Object)String.format("Skipping candidate component %s with null class name", candidateComponent));
                continue;
            }
            try {
                Class cls = ClassUtils.forName((String)className, (ClassLoader)applicationContext.getClassLoader());
                ReflectionUtils.MethodFilter filter = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Command.class);
                Set methods = MethodIntrospector.selectMethods((Class)cls, (ReflectionUtils.MethodFilter)filter);
                for (Method method2 : methods) {
                    CommandFactoryBean factoryBean = new CommandFactoryBean(method2);
                    factoryBean.setApplicationContext(applicationContext);
                    commandRegistry.registerCommand(factoryBean.getObject());
                }
            }
            catch (ClassNotFoundException e) {
                throw new ShellConfigurationException("Unable to configure commands from class " + className, (Throwable)e);
            }
        }
    }
}

