/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config;

import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.session.data.redis.config.ConfigureRedisAction;

public class ConfigureNotifyKeyspaceEventsAction
implements ConfigureRedisAction {
    static final String CONFIG_NOTIFY_KEYSPACE_EVENTS = "notify-keyspace-events";

    @Override
    public void configure(RedisConnection connection) {
        boolean A;
        String notifyOptions = this.getNotifyOptions(connection);
        String customizedNotifyOptions = notifyOptions;
        if (!customizedNotifyOptions.contains("E")) {
            customizedNotifyOptions = customizedNotifyOptions + "E";
        }
        if (!(A = customizedNotifyOptions.contains("A")) && !customizedNotifyOptions.contains("g")) {
            customizedNotifyOptions = customizedNotifyOptions + "g";
        }
        if (!A && !customizedNotifyOptions.contains("x")) {
            customizedNotifyOptions = customizedNotifyOptions + "x";
        }
        if (!notifyOptions.equals(customizedNotifyOptions)) {
            connection.setConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS, customizedNotifyOptions);
        }
    }

    private String getNotifyOptions(RedisConnection connection) {
        try {
            List config = connection.getConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS);
            if (config.size() < 2) {
                return "";
            }
            return (String)config.get(1);
        }
        catch (InvalidDataAccessApiUsageException e) {
            throw new IllegalStateException("Unable to configure Redis to keyspace notifications. See http://docs.spring.io/spring-session/docs/current/reference/html5/#api-redisoperationssessionrepository-sessiondestroyedevent", e);
        }
    }
}

