/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSession;
import org.springframework.session.SessionRepository;

public class MapSessionRepository
implements SessionRepository<ExpiringSession> {
    private Integer defaultMaxInactiveInterval;
    private final Map<String, ExpiringSession> sessions;

    public MapSessionRepository() {
        this(new ConcurrentHashMap<String, ExpiringSession>());
    }

    public MapSessionRepository(Map<String, ExpiringSession> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException("sessions cannot be null");
        }
        this.sessions = sessions;
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Override
    public void save(ExpiringSession session) {
        this.sessions.put(session.getId(), new MapSession(session));
    }

    @Override
    public ExpiringSession getSession(String id) {
        ExpiringSession saved = this.sessions.get(id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.delete(saved.getId());
            return null;
        }
        return new MapSession(saved);
    }

    @Override
    public void delete(String id) {
        this.sessions.remove(id);
    }

    @Override
    public ExpiringSession createSession() {
        MapSession result = new MapSession();
        if (this.defaultMaxInactiveInterval != null) {
            result.setMaxInactiveIntervalInSeconds(this.defaultMaxInactiveInterval);
        }
        return result;
    }
}

