/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.Hazelcast4IndexedSessionRepository;
import org.springframework.session.hazelcast.HazelcastFlushMode;
import org.springframework.session.hazelcast.HazelcastIndexedSessionRepository;
import org.springframework.session.hazelcast.config.annotation.SpringSessionHazelcastInstance;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class HazelcastHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String sessionMapName = "spring:session:sessions";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private HazelcastInstance hazelcastInstance;
    private ApplicationEventPublisher applicationEventPublisher;
    private IndexResolver<Session> indexResolver;
    private List<SessionRepositoryCustomizer<HazelcastIndexedSessionRepository>> sessionRepositoryCustomizers;
    private List<SessionRepositoryCustomizer<Hazelcast4IndexedSessionRepository>> hazelcast4SessionRepositoryCustomizers;
    private static final boolean hazelcast4;

    @Bean
    public SessionRepository<?> sessionRepository() {
        if (hazelcast4) {
            return this.createHazelcast4IndexedSessionRepository();
        }
        return this.createHazelcastIndexedSessionRepository();
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    @Deprecated
    public void setHazelcastFlushMode(HazelcastFlushMode hazelcastFlushMode) {
        this.setFlushMode(hazelcastFlushMode.getFlushMode());
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    @Autowired
    public void setHazelcastInstance(@SpringSessionHazelcastInstance ObjectProvider<HazelcastInstance> springSessionHazelcastInstance, ObjectProvider<HazelcastInstance> hazelcastInstance) {
        HazelcastInstance hazelcastInstanceToUse = (HazelcastInstance)springSessionHazelcastInstance.getIfAvailable();
        if (hazelcastInstanceToUse == null) {
            hazelcastInstanceToUse = (HazelcastInstance)hazelcastInstance.getObject();
        }
        this.hazelcastInstance = hazelcastInstanceToUse;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<HazelcastIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    @Autowired(required=false)
    public void setHazelcast4SessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<Hazelcast4IndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.hazelcast4SessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        String sessionMapNameValue = attributes.getString("sessionMapName");
        if (StringUtils.hasText((String)sessionMapNameValue)) {
            this.sessionMapName = sessionMapNameValue;
        }
        FlushMode flushMode = (FlushMode)attributes.getEnum("flushMode");
        HazelcastFlushMode hazelcastFlushMode = (HazelcastFlushMode)attributes.getEnum("hazelcastFlushMode");
        if (flushMode == FlushMode.ON_SAVE && hazelcastFlushMode != HazelcastFlushMode.ON_SAVE) {
            flushMode = hazelcastFlushMode.getFlushMode();
        }
        this.flushMode = flushMode;
        this.saveMode = (SaveMode)attributes.getEnum("saveMode");
    }

    private HazelcastIndexedSessionRepository createHazelcastIndexedSessionRepository() {
        HazelcastIndexedSessionRepository sessionRepository = new HazelcastIndexedSessionRepository(this.hazelcastInstance);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (StringUtils.hasText((String)this.sessionMapName)) {
            sessionRepository.setSessionMapName(this.sessionMapName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    private Hazelcast4IndexedSessionRepository createHazelcast4IndexedSessionRepository() {
        Hazelcast4IndexedSessionRepository sessionRepository = new Hazelcast4IndexedSessionRepository(this.hazelcastInstance);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (StringUtils.hasText((String)this.sessionMapName)) {
            sessionRepository.setSessionMapName(this.sessionMapName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        this.hazelcast4SessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    static {
        ClassLoader classLoader = HazelcastHttpSessionConfiguration.class.getClassLoader();
        hazelcast4 = ClassUtils.isPresent((String)"com.hazelcast.map.IMap", (ClassLoader)classLoader);
    }
}

