/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.FlushMode;
import org.springframework.session.MapSession;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisSessionMapper;
import org.springframework.util.Assert;

public class RedisSessionRepository
implements SessionRepository<RedisSession> {
    private static final String DEFAULT_KEY_NAMESPACE = "spring:session:";
    private final RedisOperations<String, Object> sessionRedisOperations;
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private String keyNamespace = "spring:session:";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;

    public RedisSessionRepository(RedisOperations<String, Object> sessionRedisOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations mut not be null");
        this.sessionRedisOperations = sessionRedisOperations;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setKeyNamespace(String keyNamespace) {
        Assert.hasText((String)keyNamespace, (String)"keyNamespace must not be empty");
        this.keyNamespace = keyNamespace;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode must not be null");
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public RedisSession createSession() {
        MapSession cached = new MapSession();
        cached.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        RedisSession session = new RedisSession(cached, true);
        session.flushIfRequired();
        return session;
    }

    public void save(RedisSession session) {
        String key;
        Boolean sessionExists;
        if (!(session.isNew || (sessionExists = this.sessionRedisOperations.hasKey((Object)(key = this.getSessionKey(session.hasChangedSessionId() ? session.originalSessionId : session.getId())))) != null && sessionExists.booleanValue())) {
            throw new IllegalStateException("Session was invalidated");
        }
        session.save();
    }

    public RedisSession findById(String sessionId) {
        String key = this.getSessionKey(sessionId);
        Map entries = this.sessionRedisOperations.opsForHash().entries((Object)key);
        if (entries.isEmpty()) {
            return null;
        }
        MapSession session = new RedisSessionMapper(sessionId).apply(entries);
        if (session.isExpired()) {
            this.deleteById(sessionId);
            return null;
        }
        return new RedisSession(session, false);
    }

    public void deleteById(String sessionId) {
        String key = this.getSessionKey(sessionId);
        this.sessionRedisOperations.delete((Object)key);
    }

    public RedisOperations<String, Object> getSessionRedisOperations() {
        return this.sessionRedisOperations;
    }

    private String getSessionKey(String sessionId) {
        return this.keyNamespace + "sessions:" + sessionId;
    }

    private static String getAttributeKey(String attributeName) {
        return "sessionAttr:" + attributeName;
    }

    final class RedisSession
    implements Session {
        private final MapSession cached;
        private final Map<String, Object> delta = new HashMap<String, Object>();
        private boolean isNew;
        private String originalSessionId;

        RedisSession(MapSession cached, boolean isNew) {
            this.cached = cached;
            this.isNew = isNew;
            this.originalSessionId = cached.getId();
            if (this.isNew) {
                this.delta.put("creationTime", cached.getCreationTime().toEpochMilli());
                this.delta.put("maxInactiveInterval", (int)cached.getMaxInactiveInterval().getSeconds());
                this.delta.put("lastAccessedTime", cached.getLastAccessedTime().toEpochMilli());
            }
            if (this.isNew || RedisSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put(RedisSessionRepository.getAttributeKey(attributeName), cached.getAttribute(attributeName)));
            }
        }

        public String getId() {
            return this.cached.getId();
        }

        public String changeSessionId() {
            return this.cached.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            Object attributeValue = this.cached.getAttribute(attributeName);
            if (attributeValue != null && RedisSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(RedisSessionRepository.getAttributeKey(attributeName), attributeValue);
            }
            return (T)attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.delta.put(RedisSessionRepository.getAttributeKey(attributeName), attributeValue);
            this.flushIfRequired();
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        public Instant getCreationTime() {
            return this.cached.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.delta.put("lastAccessedTime", this.getLastAccessedTime().toEpochMilli());
            this.flushIfRequired();
        }

        public Instant getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.delta.put("maxInactiveInterval", (int)this.getMaxInactiveInterval().getSeconds());
            this.flushIfRequired();
        }

        public Duration getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.cached.isExpired();
        }

        private void flushIfRequired() {
            if (RedisSessionRepository.this.flushMode == FlushMode.IMMEDIATE) {
                this.save();
            }
        }

        private boolean hasChangedSessionId() {
            return !this.getId().equals(this.originalSessionId);
        }

        private void save() {
            this.saveChangeSessionId();
            this.saveDelta();
            if (this.isNew) {
                this.isNew = false;
            }
        }

        private void saveChangeSessionId() {
            if (this.hasChangedSessionId()) {
                if (!this.isNew) {
                    String originalSessionIdKey = RedisSessionRepository.this.getSessionKey(this.originalSessionId);
                    String sessionIdKey = RedisSessionRepository.this.getSessionKey(this.getId());
                    RedisSessionRepository.this.sessionRedisOperations.rename((Object)originalSessionIdKey, (Object)sessionIdKey);
                }
                this.originalSessionId = this.getId();
            }
        }

        private void saveDelta() {
            if (this.delta.isEmpty()) {
                return;
            }
            String key = RedisSessionRepository.this.getSessionKey(this.getId());
            RedisSessionRepository.this.sessionRedisOperations.opsForHash().putAll((Object)key, new HashMap<String, Object>(this.delta));
            RedisSessionRepository.this.sessionRedisOperations.expireAt((Object)key, Date.from(Instant.ofEpochMilli(this.getLastAccessedTime().toEpochMilli()).plusSeconds(this.getMaxInactiveInterval().getSeconds())));
            this.delta.clear();
        }
    }
}

