/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.expiration.support;

import java.time.Duration;
import java.util.Optional;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.expiration.SessionExpirationPolicy;
import org.springframework.util.Assert;

public class SessionExpirationPolicyCustomExpiryAdapter
implements CustomExpiry<String, Object> {
    protected static final SessionExpirationPolicy.ExpirationAction DEFAULT_EXPIRATION_ACTION = SessionExpirationPolicy.ExpirationAction.INVALIDATE;
    private final SessionExpirationPolicy sessionExpirationPolicy;

    public SessionExpirationPolicyCustomExpiryAdapter(@NonNull SessionExpirationPolicy sessionExpirationPolicy) {
        Assert.notNull((Object)sessionExpirationPolicy, (String)"SessionExpirationPolicy is required");
        this.sessionExpirationPolicy = sessionExpirationPolicy;
    }

    protected SessionExpirationPolicy getSessionExpirationPolicy() {
        return this.sessionExpirationPolicy;
    }

    @Nullable
    public ExpirationAttributes getExpiry(@Nullable Region.Entry<String, Object> regionEntry) {
        return this.resolveSession(regionEntry).flatMap(this.getSessionExpirationPolicy()::determineExpirationTimeout).map(expirationTimeout -> this.newExpirationAttributes((Duration)expirationTimeout, this.getSessionExpirationPolicy().getExpirationAction())).orElse(null);
    }

    @NonNull
    protected ExpirationAttributes newExpirationAttributes(@NonNull Duration expirationTimeout) {
        return this.newExpirationAttributes(expirationTimeout, DEFAULT_EXPIRATION_ACTION);
    }

    @NonNull
    protected ExpirationAttributes newExpirationAttributes(@NonNull Duration expirationTimeout, @Nullable SessionExpirationPolicy.ExpirationAction expirationAction) {
        int expirationTimeoutInSeconds = (int)Math.min(Integer.MAX_VALUE, Math.max(expirationTimeout.getSeconds(), 1L));
        return this.newExpirationAttributes(expirationTimeoutInSeconds, this.toGemFireExpirationAction(expirationAction));
    }

    @NonNull
    private ExpirationAttributes newExpirationAttributes(int expirationTimeInSeconds, ExpirationAction expirationAction) {
        return new ExpirationAttributes(expirationTimeInSeconds, expirationAction);
    }

    private Optional<Session> resolveSession(@Nullable Region.Entry<String, Object> regionEntry) {
        return Optional.ofNullable(regionEntry).map(Region.Entry::getValue).flatMap(this::resolveSession);
    }

    private Optional<Session> resolveSession(@Nullable Object value) {
        return Optional.ofNullable(value instanceof Session ? (Session)value : (value instanceof PdxInstance ? (Session)((PdxInstance)value).getObject() : null));
    }

    private ExpirationAction toGemFireExpirationAction(SessionExpirationPolicy.ExpirationAction expirationAction) {
        switch (SessionExpirationPolicy.ExpirationAction.defaultIfNull(expirationAction)) {
            case DESTROY: {
                return ExpirationAction.DESTROY;
            }
        }
        return ExpirationAction.INVALIDATE;
    }
}

