/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.registration;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialCreationOptions;
import org.springframework.security.web.webauthn.registration.PublicKeyCredentialCreationOptionsRepository;
import org.springframework.util.Assert;

public class HttpSessionPublicKeyCredentialCreationOptionsRepository
implements PublicKeyCredentialCreationOptionsRepository {
    static final String DEFAULT_ATTR_NAME = PublicKeyCredentialCreationOptions.class.getName().concat("ATTR_NAME");
    private String attrName = DEFAULT_ATTR_NAME;

    @Override
    public void save(HttpServletRequest request, HttpServletResponse response, @Nullable PublicKeyCredentialCreationOptions options) {
        request.getSession().setAttribute(this.attrName, (Object)options);
    }

    @Override
    public @Nullable PublicKeyCredentialCreationOptions load(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (PublicKeyCredentialCreationOptions)session.getAttribute(this.attrName);
    }

    public void setAttrName(String attrName) {
        Assert.notNull((Object)attrName, (String)"attrName cannot be null");
        this.attrName = attrName;
    }
}

