/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientOutputs;
import org.springframework.security.web.webauthn.api.CredentialPropertiesOutput;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientOutputs;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

class AuthenticationExtensionsClientOutputsDeserializer
extends StdDeserializer<AuthenticationExtensionsClientOutputs> {
    private static final Log logger = LogFactory.getLog(AuthenticationExtensionsClientOutputsDeserializer.class);

    AuthenticationExtensionsClientOutputsDeserializer() {
        super(AuthenticationExtensionsClientOutputs.class);
    }

    public AuthenticationExtensionsClientOutputs deserialize(JsonParser parser, DeserializationContext ctxt) throws JacksonException {
        JsonToken startObject;
        ArrayList outputs = new ArrayList();
        String key = parser.nextName();
        while (key != null && (startObject = parser.nextValue()) == JsonToken.START_OBJECT) {
            if ("credProps".equals(key)) {
                CredentialPropertiesOutput output = (CredentialPropertiesOutput)parser.readValueAs(CredentialPropertiesOutput.class);
                outputs.add(output);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping unknown extension with id " + key));
                }
                parser.nextValue();
            }
            key = parser.nextName();
        }
        return new ImmutableAuthenticationExtensionsClientOutputs(outputs);
    }
}

