/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientOutputs;
import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;
import org.springframework.security.web.webauthn.api.AuthenticatorResponse;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;
import org.springframework.util.Assert;

public final class PublicKeyCredential<R extends AuthenticatorResponse>
implements Serializable {
    private static final long serialVersionUID = -1864035469276082606L;
    private final String id;
    private final @Nullable PublicKeyCredentialType type;
    private final Bytes rawId;
    private final R response;
    private final @Nullable AuthenticatorAttachment authenticatorAttachment;
    private final @Nullable AuthenticationExtensionsClientOutputs clientExtensionResults;

    private PublicKeyCredential(String id, @Nullable PublicKeyCredentialType type, Bytes rawId, R response, @Nullable AuthenticatorAttachment authenticatorAttachment, @Nullable AuthenticationExtensionsClientOutputs clientExtensionResults) {
        this.id = id;
        this.type = type;
        this.rawId = rawId;
        this.response = response;
        this.authenticatorAttachment = authenticatorAttachment;
        this.clientExtensionResults = clientExtensionResults;
    }

    public String getId() {
        return this.id;
    }

    public @Nullable PublicKeyCredentialType getType() {
        return this.type;
    }

    public Bytes getRawId() {
        return this.rawId;
    }

    public R getResponse() {
        return this.response;
    }

    public @Nullable AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public @Nullable AuthenticationExtensionsClientOutputs getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    public static <T extends AuthenticatorResponse> PublicKeyCredentialBuilder<T> builder() {
        return new PublicKeyCredentialBuilder();
    }

    public static final class PublicKeyCredentialBuilder<R extends AuthenticatorResponse> {
        private String id;
        private @Nullable PublicKeyCredentialType type;
        private Bytes rawId;
        private R response;
        private @Nullable AuthenticatorAttachment authenticatorAttachment;
        private @Nullable AuthenticationExtensionsClientOutputs clientExtensionResults;

        private PublicKeyCredentialBuilder() {
        }

        public PublicKeyCredentialBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PublicKeyCredentialBuilder type(PublicKeyCredentialType type) {
            this.type = type;
            return this;
        }

        public PublicKeyCredentialBuilder rawId(Bytes rawId) {
            this.rawId = rawId;
            return this;
        }

        public PublicKeyCredentialBuilder response(R response) {
            this.response = response;
            return this;
        }

        public PublicKeyCredentialBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public PublicKeyCredentialBuilder clientExtensionResults(AuthenticationExtensionsClientOutputs clientExtensionResults) {
            this.clientExtensionResults = clientExtensionResults;
            return this;
        }

        public PublicKeyCredential<R> build() {
            Assert.notNull((Object)this.id, (String)"id cannot be null");
            Assert.notNull((Object)this.rawId, (String)"rawId cannot be null");
            Assert.notNull(this.response, (String)"response cannot be null");
            return new PublicKeyCredential<R>(this.id, this.type, this.rawId, this.response, this.authenticatorAttachment, this.clientExtensionResults);
        }
    }
}

