/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;
import org.springframework.security.web.webauthn.api.ResidentKeyRequirement;
import org.springframework.security.web.webauthn.api.UserVerificationRequirement;

public final class AuthenticatorSelectionCriteria {
    private final @Nullable AuthenticatorAttachment authenticatorAttachment;
    private final @Nullable ResidentKeyRequirement residentKey;
    private final @Nullable UserVerificationRequirement userVerification;

    private AuthenticatorSelectionCriteria(@Nullable AuthenticatorAttachment authenticatorAttachment, @Nullable ResidentKeyRequirement residentKey, @Nullable UserVerificationRequirement userVerification) {
        this.authenticatorAttachment = authenticatorAttachment;
        this.residentKey = residentKey;
        this.userVerification = userVerification;
    }

    public @Nullable AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public @Nullable ResidentKeyRequirement getResidentKey() {
        return this.residentKey;
    }

    public @Nullable UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public static AuthenticatorSelectionCriteriaBuilder builder() {
        return new AuthenticatorSelectionCriteriaBuilder();
    }

    public static final class AuthenticatorSelectionCriteriaBuilder {
        private @Nullable AuthenticatorAttachment authenticatorAttachment;
        private @Nullable ResidentKeyRequirement residentKey;
        private @Nullable UserVerificationRequirement userVerification;

        private AuthenticatorSelectionCriteriaBuilder() {
        }

        public AuthenticatorSelectionCriteriaBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public AuthenticatorSelectionCriteriaBuilder residentKey(ResidentKeyRequirement residentKey) {
            this.residentKey = residentKey;
            return this;
        }

        public AuthenticatorSelectionCriteriaBuilder userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        public AuthenticatorSelectionCriteria build() {
            return new AuthenticatorSelectionCriteria(this.authenticatorAttachment, this.residentKey, this.userVerification);
        }
    }
}

